/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.ES6CodeStyleImportsPanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListItemsDialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCodeStyleImportsPanel
extends ES6CodeStyleImportsPanel {
    protected TextFieldWithBrowseButton myBlacklistImports;

    public TypeScriptCodeStyleImportsPanel() {
        super(TypeScriptCodeStyleSettings.class);
    }

    @Override
    protected void fillGeneralPanel(@NotNull OptionGroup group) {
        if (group == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(0);
        }
        super.fillGeneralPanel(group);
        this.myBlacklistImports = new TextFieldWithBrowseButton();
        TypeScriptCodeStyleImportsPanel.customizeField(this.myBlacklistImports);
        LabeledComponent bannedListWithLabel = LabeledComponent.create((JComponent)this.myBlacklistImports, (String)JSBundle.message((String)"typescript.import.options.blacklist.title", (Object[])new Object[0]), (String)"West");
        bannedListWithLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)bannedListWithLabel, "West");
        group.add((JComponent)wrapper);
    }

    @Override
    public boolean isModified(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(1);
        }
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        return super.isModified(commonSettings) || !StringUtil.equals((CharSequence)TypeScriptCodeStyleImportsPanel.getBannedListString(jsSettings), (CharSequence)this.myBlacklistImports.getText());
    }

    @Override
    public void reset(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(2);
        }
        super.reset(commonSettings);
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.myBlacklistImports.setText(TypeScriptCodeStyleImportsPanel.getBannedListString(jsSettings));
    }

    @Override
    public void apply(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(3);
        }
        super.apply(commonSettings);
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        TypeScriptCodeStyleImportsPanel.applyBlacklist(jsSettings, this.myBlacklistImports.getText());
    }

    private static String getBannedListString(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(4);
        }
        return jsSettings.BLACKLIST_IMPORTS;
    }

    @Override
    @NotNull
    protected String getAbsolutePathCheckboxTitle() {
        String string = JSBundle.message((String)"typescript.import.options.use.config", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void customizeField(TextFieldWithBrowseButton uiField) {
        ListItemsDialogWrapper.installListItemsDialogForTextField((TextFieldWithBrowseButton)uiField, () -> new ListItemsDialogWrapper(JSBundle.message((String)"typescript.import.options.blacklist.change.button", (Object[])new Object[0])){

            protected String createAddItemDialog() {
                return Messages.showInputDialog((String)JSBundle.message((String)"typescript.import.options.blacklist.change.dialog.text", (Object[])new Object[0]), (String)JSBundle.message((String)"typescript.import.options.blacklist.change.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            }
        });
    }

    private static void applyBlacklist(@NotNull JSCodeStyleSettings jsSettings, @Nullable String value) {
        if (jsSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(6);
        }
        jsSettings.BLACKLIST_IMPORTS = StringUtil.notNullize((String)StringUtil.trim((String)value));
    }

    @Override
    protected boolean getUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings) {
        JSCodeStyleSettings.BooleanWithGlobalOption value;
        if (jsSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(7);
        }
        return (value = jsSettings.IMPORT_USE_NODE_RESOLUTION) == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? this.appSettings.isUseNodeModulesResolutionImports() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    @Override
    protected void applyUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (jsSettings == null) {
            TypeScriptCodeStyleImportsPanel.$$$reportNull$$$0(8);
        }
        if (this.appSettings.isUseNodeModulesResolutionImports() == value) {
            jsSettings.IMPORT_USE_NODE_RESOLUTION = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_USE_NODE_RESOLUTION = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/formatter/TypeScriptCodeStyleImportsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePathCheckboxTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillGeneralPanel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBannedListString";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyBlacklist";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUseNodeModulesResolution";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyUseNodeModulesResolution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

