/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.inspection.TypescriptRemoveTypeDeclarationQuickFix;
import com.intellij.lang.typescript.inspection.TypescriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptExplicitMemberTypeInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public boolean myPreferExplicitLocalVariableTypes;
    public boolean myPreferExplicitReturnTypes;

    public TypescriptExplicitMemberTypeInspection() {
        this(false, true);
    }

    public TypescriptExplicitMemberTypeInspection(boolean explicitVariableTypes, boolean explicitReturnTypes) {
        this.myPreferExplicitLocalVariableTypes = explicitVariableTypes;
        this.myPreferExplicitReturnTypes = explicitReturnTypes;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.variables.option", (Object[])new Object[0]), "myPreferExplicitLocalVariableTypes");
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.functions.option", (Object[])new Object[0]), "myPreferExplicitReturnTypes");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                this.visitNode((JSElement)node, TypescriptExplicitMemberTypeInspection.this.myPreferExplicitLocalVariableTypes);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isConstructor()) {
                    return;
                }
                this.visitNode((JSElement)node, TypescriptExplicitMemberTypeInspection.this.myPreferExplicitReturnTypes);
            }

            private void visitNode(JSElement node, boolean preferExplicitTypes) {
                if (!TypescriptExplicitMemberTypeInspection.isSupportedDialect(node)) {
                    return;
                }
                if (ErrorUtil.containsError((PsiElement)node)) {
                    return;
                }
                this.inspectForRedundantTypeDeclaration(node, preferExplicitTypes);
                this.inspectForMissingDeclaration(node, preferExplicitTypes);
            }

            private void inspectForMissingDeclaration(@NotNull JSElement node, boolean preferExplicitTypes) {
                JSFunction function;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSFunction jSFunction = function = node instanceof JSFunction ? (JSFunction)node : null;
                if (function != null && function.getKind() == JSFunction.FunctionKind.SETTER) {
                    return;
                }
                if (TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement((PsiElement)node) == null && TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)node) != null) {
                    ProblemHighlightType highlightType = preferExplicitTypes ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                    PsiElement identifier = ((PsiNameIdentifierOwner)node).getNameIdentifier();
                    if (identifier == null) {
                        return;
                    }
                    if (holder.isOnTheFly() || preferExplicitTypes) {
                        holder.registerProblem(identifier, JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]), highlightType, new LocalQuickFix[]{new TypescriptSpecifyTypeExplicitlyQuickFix()});
                    }
                }
            }

            private void inspectForRedundantTypeDeclaration(@NotNull JSElement declarationOwner, boolean preferExplicitTypes) {
                ProblemHighlightType highlightType;
                JSElement declarationElement;
                if (declarationOwner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((declarationElement = TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement((PsiElement)declarationOwner)) == null) {
                    return;
                }
                JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)declarationOwner);
                JSType declaredType = JSPsiImplUtils.getTypeFromDeclaration(declarationOwner);
                boolean isRedundant = !preferExplicitTypes && TypescriptExplicitMemberTypeInspection.isRedundantDeclaration(inferredType, declaredType);
                LocalQuickFix[] quickFixes = new LocalQuickFix[]{new TypescriptRemoveTypeDeclarationQuickFix()};
                String message = JSBundle.message((String)(isRedundant ? "typescript.redundant.declaration" : "typescript.remove.type.declaration"), (Object[])new Object[0]);
                ProblemHighlightType problemHighlightType = highlightType = isRedundant ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                if (isRedundant || holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)declarationElement, message, highlightType, quickFixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declarationOwner";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForMissingDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectForRedundantTypeDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static boolean isSupportedDialect(@NotNull JSElement node) {
        DialectOptionHolder dialect;
        if (node == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(1);
        }
        return (dialect = DialectDetector.dialectOfElement((PsiElement)node)) != null && dialect.isTypeScript;
    }

    private static boolean isRedundantDeclaration(@Nullable JSType inferredType, @Nullable JSType declaredType) {
        inferredType = JSTypeUtils.getValuableType(inferredType);
        return (declaredType = JSTypeUtils.getValuableType(declaredType)) != null && inferredType != null && !JSTypeCastUtil.isAlwaysAssignableType(declaredType) && !JSTypeCastUtil.isAlwaysAssignableType(inferredType) && TypescriptExplicitMemberTypeInspection.isEquivalent(inferredType, declaredType);
    }

    private static boolean isEquivalent(@NotNull JSType inferredType, @NotNull JSType declaredType) {
        Pair<TypeScriptEnum, TypeScriptEnumField> parentAndField;
        if (inferredType == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(2);
        }
        if (declaredType == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(3);
        }
        return inferredType.isEquivalentTo(declaredType, new ProcessingContext()) || inferredType instanceof JSStringLiteralTypeImpl && declaredType instanceof JSStringType && !(declaredType instanceof JSStringLiteralTypeImpl) || inferredType instanceof JSNumberLiteralTypeImpl && declaredType instanceof JSNumberType && !(declaredType instanceof JSNumberLiteralTypeImpl) || inferredType instanceof JSBooleanLiteralTypeImpl && declaredType instanceof JSBooleanType && !(declaredType instanceof JSBooleanLiteralTypeImpl) || inferredType instanceof JSTypeImpl && ((JSTypeImpl)inferredType).isEnumLiteral() && declaredType instanceof JSTypeImpl && !((JSTypeImpl)declaredType).isEnumLiteral() && ((JSTypeImpl)declaredType).isEnum() && (parentAndField = TypeScriptUtil.getEnumLiteralParentAndField((JSTypeImpl)inferredType)) != null && Objects.equals(TypeScriptUtil.getEnumDeclaration((JSTypeImpl)declaredType), parentAndField.first);
    }

    @Nullable
    public static JSElement getTypeDeclarationElement(@NotNull PsiElement element) {
        if (element == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof JSTypeDeclaration) {
            return (JSElement)element;
        }
        if (element.getParent() instanceof JSTypeDeclaration) {
            return (JSElement)element.getParent();
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return (JSElement)((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return (JSElement)((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Nullable
    public static JSType getInferredType(@NotNull PsiElement element) {
        if (element == null) {
            TypescriptExplicitMemberTypeInspection.$$$reportNull$$$0(5);
        }
        return TypeFromUsageDetector.detectTypeFromUsage(element, element.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedDialect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDeclarationElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

