/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptLibraries {
    private static final String EXTERNAL_DIR = "external";
    @NotNull
    private final Set<VirtualFile> myAllLibsIncludeInvalid;
    @NotNull
    private final Set<VirtualFile> myAllLibs;
    @NotNull
    private final Set<VirtualFile> myES6Libs;
    @NotNull
    private final Set<VirtualFile> myDefaultLibs;
    private final long myModificationId;

    public TypeScriptLibraries() {
        VirtualFile defaultLib = TypeScriptLibraries.getTypeScriptPredefinedLibFile("lib.d.ts");
        VirtualFile es6Lib = TypeScriptLibraries.getTypeScriptPredefinedLibFile("lib.es6.d.ts");
        HashSet libsIncludeInvalid = ContainerUtil.newHashSet();
        if (defaultLib != null) {
            libsIncludeInvalid.add(defaultLib);
        }
        if (es6Lib != null) {
            libsIncludeInvalid.add(es6Lib);
        }
        libsIncludeInvalid.addAll(TypeScriptLibraries.createExtendedLibs());
        this.myDefaultLibs = TypeScriptLibraries.createLibSetIfValid(defaultLib);
        this.myES6Libs = TypeScriptLibraries.createLibSetIfValid(es6Lib);
        this.myAllLibsIncludeInvalid = Collections.unmodifiableSet(libsIncludeInvalid);
        this.myAllLibs = Collections.unmodifiableSet(libsIncludeInvalid.stream().filter(TypeScriptLibraries::isValid).collect(Collectors.toSet()));
        this.myModificationId = this.myAllLibs.stream().mapToLong(el -> el.getModificationStamp()).reduce((el, res) -> el + 23L * res).orElse(0L);
    }

    @NotNull
    public Set<VirtualFile> getES6Libs() {
        Set<VirtualFile> set = this.myES6Libs;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getDefaultLibs() {
        Set<VirtualFile> set = this.myDefaultLibs;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAllLibs() {
        Set<VirtualFile> set = this.myAllLibs;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static boolean isValid(@Nullable VirtualFile file) {
        return file != null && file.isValid();
    }

    @NotNull
    private static Set<VirtualFile> createLibSetIfValid(@Nullable VirtualFile file) {
        Set set = TypeScriptLibraries.isValid(file) ? ContainerUtil.immutableSet((Object[])new VirtualFile[]{file}) : Collections.emptySet();
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> createExtendedLibs() {
        ArrayList toProcess = ContainerUtil.newArrayList();
        toProcess.addAll(TypeScriptLibraryProvider.LIBS_EXTENDED);
        Set<VirtualFile> set = toProcess.stream().map(name -> TypeScriptLibraries.getTypeScriptPredefinedLibFile(name)).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    private static VirtualFile getTypeScriptPredefinedLibFile(@NotNull String name) {
        LocalFileSystem localFileSystem;
        if (name == null) {
            TypeScriptLibraries.$$$reportNull$$$0(5);
        }
        if ((localFileSystem = TypeScriptLibraries.getFileSystem()) == null) {
            return null;
        }
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL_DIR + File.separator + name);
        VirtualFile file = JSLibraryUtil.findFileByIoFile(localFileSystem, ioFile);
        return JSLibraryUtil.convertFile(file);
    }

    @Nullable
    private static LocalFileSystem getFileSystem() {
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (!(fileSystem instanceof LocalFileSystem)) {
            return null;
        }
        return (LocalFileSystem)fileSystem;
    }

    @NotNull
    public Collection<VirtualFile> getFilesToRefresh() {
        VirtualFile defaultLib = (VirtualFile)ContainerUtil.getFirstItem(this.myDefaultLibs);
        if (defaultLib != null) {
            List<VirtualFile> list = Collections.singletonList(defaultLib.getParent());
            if (list == null) {
                TypeScriptLibraries.$$$reportNull$$$0(6);
            }
            return list;
        }
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL_DIR);
        LocalFileSystem system = TypeScriptLibraries.getFileSystem();
        if (system != null) {
            VirtualFile file = JSLibraryUtil.findFileByIoFile(system, ioFile);
            List<VirtualFile> list = Collections.singletonList(JSLibraryUtil.convertFile(file));
            if (list == null) {
                TypeScriptLibraries.$$$reportNull$$$0(7);
            }
            return list;
        }
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(8);
        }
        return set;
    }

    public long getModificationId() {
        return this.myModificationId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getES6Libs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLibs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibSetIfValid";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtendedLibs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptPredefinedLibFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

