/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static TypeScriptGenericTypesEvaluator INSTANCE = null;

    protected TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSReferenceExpression methodExpression) {
        JSType rawQualifier;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isJavaScript((PsiElement)qualifier)) {
            type = super.evaluateGenericsFromQualifier(type, qualifier, methodExpression);
        }
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(type);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(type);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(type instanceof JSTypeImpl)) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
                }
                return jSType;
            }
            JSTypeImpl jsType = (JSTypeImpl)type;
            if (!jsType.isLocal()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
                }
                return jSType;
            }
        }
        if ((rawQualifier = JSResolveUtil.getExpressionJSType(qualifier)) != null && hasThisGenericType) {
            type = TypeScriptGenericTypesEvaluator.evaluateThisType(type, rawQualifier);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSType jSType = type = TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, rawQualifier, sourceElement);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    private static JSType evaluateThisType(@NotNull JSType type, @NotNull JSType qualifierType) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return type.transformTypeHierarchy(jsType -> {
            if (qualifierType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
            }
            if (jsType instanceof TypeScriptGenericThisTypeImpl) {
                return qualifierType;
            }
            return jsType;
        });
    }

    @Contract(value="!null,_,_ -> !null")
    private static JSType evaluateGenericsFromQualifierType(@Nullable JSType type, @Nullable JSType qualifierType, @Nullable PsiElement sourceElement) {
        JSTypeSubstitutor substitutor;
        if (type != null && qualifierType != null && !(substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, sourceElement)).isEmpty()) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor);
        }
        return type;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(typeToProcess, sourceElement);
                substitutor.putAll((Map)candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            Map<String, JSType> outerArguments = genericType.getOuterArguments();
            if (outerArguments != null) {
                substitutor.putAll(outerArguments);
            }
        } else if (qualifierType instanceof JSRecordType) {
            MultiMap<String, JSType> generics;
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null && !(generics = TypeScriptGenericTypesEvaluator.findGenericsTypeValues(qualifierType, objectType)).isEmpty()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.intersectGenerics(generics, sourceElement, null);
                substitutor.putAll((Map)candidate);
                JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
                }
                return jSTypeSubstitutor;
            }
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                Ref ref = Ref.create((Object)substitutor);
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, (Ref<JSTypeSubstitutor>)ref);
                if (ref.isNull()) continue;
                substitutor = (JSTypeSubstitutor)ref.get();
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        if (qualifierClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluator::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        Ref substitutor = Ref.create();
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, (Ref<JSTypeSubstitutor>)substitutor);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, (Map)substitutor.get());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    public static void processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, typeArgumentsList, expectedGenericOwnerClass, substitutor, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor, @NotNull Set<JSClass> visitedClasses) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (visitedClasses == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if (!(contextClass instanceof TypeScriptTypeParameterListOwner) || expectedGenericOwnerClass == null) {
            return true;
        }
        if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            JSTypeSubstitutor oldSubstitutor = (JSTypeSubstitutor)substitutor.get();
            if (oldSubstitutor != null && genericArguments != null) {
                genericArguments.putAll((Map)oldSubstitutor);
            }
            substitutor.set((Object)genericArguments);
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = contextClass.getExtendsList();
        JSReferenceList implementsList = contextClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            for (Pair reference : superReferences) {
                if (reference.second == null || ((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), (Map<String, JSType>)typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, expectedGenericOwnerClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, expectedGenericOwnerClass, substitutor, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable Map<String, JSType> typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        if (typeParameterListOwner == null) {
            return null;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            return null;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = new JSTypeSubstitutor();
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, int paramToSkip) {
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            JSTypeSubstitutor map = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                    List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                    TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
                    if (map != null && argumentsFromSuper != null) {
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
                    type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, type);
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)map, false, reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, reporter, paramToSkip);
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        JSTypeSubstitutor candidate;
        PsiElement parent;
        boolean isFunctionCallContext;
        if (place == null || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll((Map)additionalSubstitutor);
        }
        boolean bl = isFunctionCallContext = (parent = place.getParent()) instanceof JSCallExpression && member instanceof TypeScriptTypeParameterListOwner;
        if (isFunctionCallContext) {
            candidate = TypeScriptGenericTypesEvaluator.inferGenericTypesForCall(member, (JSCallExpression)parent, null);
            candidate.forEach((key, value) -> {
                if (!(value instanceof JSAnyType)) {
                    substitutor.put(key, value);
                }
            });
        }
        if (qualifierType != null) {
            candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, member);
            substitutor.putAll((Map)candidate);
        }
        if (isFunctionCallContext) {
            substitutor.putAll((Map)TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(member, parent, substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        JSExpression qualifier = referenceExpression.getQualifier();
        JSType qualifierType = null;
        if (qualifier != null) {
            qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        }
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember((PsiElement)functionItem, place, qualifierType, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember((PsiElement)member, place, qualifierType, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        JSTypeEvaluationResult result = (JSTypeEvaluationResult)exprTypeRef.get();
        if (result == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isExplicitlyDeclared() && typeSource.isExplicitlyDeclared());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull Map<String, JSType> genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        if (typeParameters.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            String name;
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (typeArguments.length > 0 && type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null || genericArguments.containsKey(name) && type == null) continue;
            genericArguments.put(name, type);
        }
    }

    @Contract(value="_,_,!null -> !null")
    public static JSTypeSubstitutor addExplicitGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            return genericArguments == null ? null : new JSTypeSubstitutor((Map)genericArguments);
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor((Map)genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, (Map<String, JSType>)substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, (Map<String, JSType>)substitutor);
        }
        return substitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : callExpression.getArguments()) {
            argumentTypes.add(TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression)));
        }
        List list = argumentTypes;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull JSExpression expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        JSType jSType = type == null ? JSAnyType.get((PsiElement)expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        if (!source.isTypeScript() || !source.isExplicitlyDeclared()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
            }
            return list;
        }
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, source.getSourceElement());
        for (PsiElement psiElement : resolveResults.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            result.add((JSClass)psiElement);
        }
        List list = result;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters, false);
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters, boolean callEnv) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name;
            TypeScriptType constraint = parameter.getTypeConstraint();
            JSType constraintType = null;
            if (constraint != null) {
                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
            }
            if ((name = parameter.getName()) == null) continue;
            generics.add(new JSGenericParameterImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true), constraintType, callEnv));
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSType resultType = TypeScriptGenericTypesEvaluator.wrapReturnTypeWithGenerics(functionType, callExpression, defaultParamsSubstitutor);
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSType evaluatedType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, (Map<String, JSType>)defaultParamsSubstitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
        }
        return jSType;
    }

    private static JSType wrapReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression, JSTypeSubstitutor defaultParamsSubstitutor) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        if (callExpression instanceof JSNewExpression && sourceElement instanceof TypeScriptClass) {
            JSType returnType = functionType.getReturnType();
            TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
            if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
                List<JSType> defaultGenerics;
                JSTypeDeclaration[] arguments = TypeScriptPsiUtil.getNewExpressionTypeArguments((PsiElement)callExpression);
                if (arguments.length == 0) {
                    Arrays.stream(typeParameters).forEach(el -> {
                        JSType cfr_ignored_0 = (JSType)defaultParamsSubstitutor.put((Object)el.getName(), (Object)TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                    });
                    defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
                } else {
                    defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(arguments, (Map<String, JSType>)defaultParamsSubstitutor);
                }
                JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
                return new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            }
        }
        return functionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 17: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 29: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 43: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForQualifierType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 52: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateThisType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForQualifierType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParameterExpressionType";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "wrapReturnTypeWithGenerics";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateThisType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

