/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.checkers;

import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptConfigIncludeBase
implements TypeScriptFileInclude {
    private static final FileType[] JS_FILE_TYPES = new FileType[]{JavaScriptSupportLoader.JAVASCRIPT, JSXHarmonyFileType.INSTANCE};
    @Nullable
    protected final Pattern myExcludePattern;
    @NotNull
    protected final VirtualFile myConfigDirectory;
    @NotNull
    protected final Collection<VirtualFile> myTypeRoots;
    @NotNull
    protected final Collection<String> myTypes;
    @NotNull
    protected final Collection<VirtualFile> myRootDirs;
    @NotNull
    private final Collection<String> myExcludePatterns;
    private final boolean myAllowJs;
    @NotNull
    private final NotNullLazyValue<Collection<VirtualFile>> myTypesDirectories;

    protected static boolean containsFile(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> files) {
        if (file == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(0);
        }
        if (files == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(1);
        }
        if (files.size() > 0) {
            for (VirtualFile includedFile : files) {
                if ((!includedFile.isDirectory() || !VfsUtilCore.isAncestor((VirtualFile)includedFile, (VirtualFile)file, (boolean)true)) && (includedFile.isDirectory() || !includedFile.equals(file))) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean checkPattern(@NotNull String path, @NotNull Pattern pattern) {
        if (path == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(3);
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }

    @Nullable
    protected static Pattern createPattern(@Nullable String pattern, VirtualFile configDir) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, TypeScriptConfigIncludeBase.isCaseSensitive(configDir) ? 0 : 2);
    }

    private static boolean isCaseSensitive(VirtualFile configDir) {
        VirtualFileSystem fs = configDir.getFileSystem();
        return fs.isCaseSensitive();
    }

    public TypeScriptConfigIncludeBase(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(4);
        }
        this.myTypesDirectories = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                if (TypeScriptConfigIncludeBase.this.myTypes.isEmpty() || TypeScriptConfigIncludeBase.this.myTypeRoots.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                ArrayList typesDirectories = ContainerUtil.newArrayList();
                for (VirtualFile virtualFile : TypeScriptConfigIncludeBase.this.myTypeRoots) {
                    for (String type : TypeScriptConfigIncludeBase.this.myTypes) {
                        VirtualFile child = virtualFile.findChild(type);
                        if (child == null || !child.isDirectory()) continue;
                        typesDirectories.add(child);
                    }
                }
                ArrayList arrayList = typesDirectories;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$1", "compute"));
            }
        };
        this.myConfigDirectory = config2.getConfigDirectory();
        this.myTypeRoots = config2.getTypeRoots();
        this.myTypes = config2.getTypes();
        this.myRootDirs = config2.getRootDirsFiles();
        this.myExcludePatterns = config2.getExcludePatterns();
        this.myExcludePattern = TypeScriptConfigIncludeBase.getExcludePattern(this.myConfigDirectory, this.myExcludePatterns);
        this.myAllowJs = config2.allowJs();
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getRootFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(5);
        }
        HashSet hashSet = ContainerUtil.newHashSet(this.getOwnRootFiles(project));
        if (hashSet == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    protected Collection<VirtualFile> getOwnRootFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(7);
        }
        Collection<VirtualFile> collection = this.getFilesForScope(this.getScope(project));
        if (collection == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    private GlobalSearchScope getScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(9);
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                return TypeScriptConfigIncludeBase.this.accept(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$2", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(10);
        }
        return delegatingGlobalSearchScope;
    }

    @Nullable
    private static Pattern getExcludePattern(@NotNull VirtualFile configDir, @Nullable Collection<String> excludePatterns) {
        if (configDir == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(11);
        }
        String wildcard = excludePatterns == null ? null : TypeScriptConfigUtil.getRegularExpressionForGlobPattern(excludePatterns, configDir, TypeScriptConfigUtil.WildCardType.EXCLUDE);
        return wildcard == null ? null : TypeScriptConfigIncludeBase.createPattern(wildcard, configDir);
    }

    public final boolean isIncludeTypesFile(@NotNull VirtualFile file) {
        boolean isEmptyTypes;
        if (file == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(12);
        }
        if (isEmptyTypes = this.myTypes.isEmpty()) {
            for (VirtualFile virtualFile : this.myTypeRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
        } else {
            for (VirtualFile typeDir : (Collection)this.myTypesDirectories.getValue()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)typeDir, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isFromRootDirs(@NotNull VirtualFile file) {
        Collection<VirtualFile> virtualFiles;
        if (file == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(13);
        }
        return !(virtualFiles = this.myRootDirs).isEmpty() && TypeScriptConfigIncludeBase.containsFile(file, virtualFiles);
    }

    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(14);
        }
        String path = file.getPath();
        if (this.myExcludePattern == null) {
            return false;
        }
        return TypeScriptConfigIncludeBase.checkPattern(path, this.myExcludePattern);
    }

    @Override
    public abstract boolean accept(@NotNull VirtualFile var1);

    @NotNull
    protected Collection<VirtualFile> getFilesForScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(15);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
            ProgressManager.checkCanceled();
            FileTypeIndex.processFiles((FileType)type, (Processor)processor, (GlobalSearchScope)scope);
        }
        if (this.myAllowJs) {
            for (FileType type : JS_FILE_TYPES) {
                ProgressManager.checkCanceled();
                FileTypeIndex.processFiles((FileType)type, (Processor)processor, (GlobalSearchScope)scope);
            }
        }
        Collection collection = processor.getResults();
        if (collection == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptConfigIncludeBase base = (TypeScriptConfigIncludeBase)o;
        if (this.myAllowJs != base.myAllowJs) {
            return false;
        }
        if (!this.myConfigDirectory.equals(base.myConfigDirectory)) {
            return false;
        }
        if (!this.myTypeRoots.equals(base.myTypeRoots)) {
            return false;
        }
        if (!this.myTypes.equals(base.myTypes)) {
            return false;
        }
        if (!this.myRootDirs.equals(base.myRootDirs)) {
            return false;
        }
        return this.myExcludePatterns.equals(base.myExcludePatterns);
    }

    public int hashCode() {
        int result = this.myConfigDirectory.hashCode();
        result = 31 * result + this.myTypeRoots.hashCode();
        result = 31 * result + this.myTypes.hashCode();
        result = 31 * result + this.myRootDirs.hashCode();
        result = 31 * result + this.myExcludePatterns.hashCode();
        result = 31 * result + (this.myAllowJs ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnRootFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootFiles";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOwnRootFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExcludePattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIncludeTypesFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFromRootDirs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

