/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends GroovyFix {
    private final CreateFieldFix myFix;
    private final GrNamedArgument myNamedArgument;

    public CreateFieldFromConstructorLabelFix(GrTypeDefinition targetClass, GrNamedArgument namedArgument) {
        this.myFix = new CreateFieldFix(targetClass);
        this.myNamedArgument = namedArgument;
    }

    @Nullable
    private String getFieldName() {
        GrArgumentLabel label = this.myNamedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    private TypeConstraint[] calculateTypeConstrains() {
        GrExpression expression = this.myNamedArgument.getExpression();
        PsiType type = null;
        if (expression != null) {
            type = expression.getType();
        }
        if (type != null) {
            return new TypeConstraint[]{SupertypeConstraint.create(type, type)};
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("create.field.from.usage", this.getFieldName());
        if (string == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Create field" == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(1);
        }
        return "Create field";
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        if (project == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(3);
        }
        this.myFix.doFix(project, ArrayUtil.EMPTY_STRING_ARRAY, this.getFieldName(), this.calculateTypeConstrains(), this.myNamedArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

