/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodParameterCountInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        if ("Method with too many parameters" == null) {
            GroovyMethodParameterCountInspectionBase.$$$reportNull$$$0(0);
        }
        return "Method with too many parameters";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum number of parameters:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' contains too many parameters (" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyMethodParameterCountInspectionBase.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodParameterCountInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            if (grMethod == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(grMethod);
            GrParameter[] parameters = grMethod.getParameters();
            int limit = GroovyMethodParameterCountInspectionBase.this.getLimit();
            if (parameters == null || parameters.length <= limit) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, parameters.length, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethod", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodParameterCountInspectionBase$Visitor", "visitMethod"));
        }
    }
}

