/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;

public class GroovyCodeStyleSettingsFacadeImpl
extends GroovyCodeStyleSettingsFacade {
    private final Project myProject;

    public GroovyCodeStyleSettingsFacadeImpl(Project project, ProjectCodeStyleSettingsManager codeStyleSettingsManager) {
        this.myProject = project;
    }

    private GroovyCodeStyleSettings getSettings() {
        return (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
    }

    @Override
    public boolean useFqClassNames() {
        return this.getSettings().USE_FQ_CLASS_NAMES;
    }

    @Override
    public boolean useFqClassNamesInJavadoc() {
        return this.getSettings().USE_FQ_CLASS_NAMES_IN_JAVADOC;
    }

    @Override
    public int staticFieldsOrderWeight() {
        return this.getSettings().STATIC_FIELDS_ORDER_WEIGHT;
    }

    @Override
    public int fieldsOrderWeight() {
        return this.getSettings().FIELDS_ORDER_WEIGHT;
    }

    @Override
    public int staticMethodsOrderWeight() {
        return this.getSettings().STATIC_METHODS_ORDER_WEIGHT;
    }

    @Override
    public int methodsOrderWeight() {
        return this.getSettings().METHODS_ORDER_WEIGHT;
    }

    @Override
    public int staticInnerClassesOrderWeight() {
        return this.getSettings().STATIC_INNER_CLASSES_ORDER_WEIGHT;
    }

    @Override
    public int innerClassesOrderWeight() {
        return this.getSettings().INNER_CLASSES_ORDER_WEIGHT;
    }

    @Override
    public int constructorsOrderWeight() {
        return this.getSettings().CONSTRUCTORS_ORDER_WEIGHT;
    }

    @Override
    public boolean insertInnerClassImports() {
        return this.getSettings().INSERT_INNER_CLASS_IMPORTS;
    }
}

