/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static boolean isEnabled(@NotNull Editor editor, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Language language;
        Project project;
        if (editor == null) {
            HandlerUtils.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            HandlerUtils.$$$reportNull$$$0(1);
        }
        if ((project = HandlerUtils.getProject(dataContext)) != null && (language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) == GroovyLanguage.INSTANCE) {
            return true;
        }
        return originalHandler == null || originalHandler.isEnabled(editor, dataContext);
    }

    public static boolean isReadOnly(@NotNull Editor editor) {
        if (editor == null) {
            HandlerUtils.$$$reportNull$$$0(2);
        }
        if (editor.isViewer()) {
            return true;
        }
        Document document = editor.getDocument();
        return !document.isWritable();
    }

    public static boolean canBeInvoked(Editor editor, Project project) {
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        return HandlerUtils.getPsiFile(editor, project) != null;
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, @NotNull DataContext dataContext) {
        if (editor == null) {
            HandlerUtils.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            HandlerUtils.$$$reportNull$$$0(4);
        }
        return HandlerUtils.getPsiFile(editor, HandlerUtils.getProject(dataContext));
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, Project project) {
        if (editor == null) {
            HandlerUtils.$$$reportNull$$$0(5);
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
    }

    @Nullable
    public static Language getLanguage(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            HandlerUtils.$$$reportNull$$$0(6);
        }
        return (Language)DataKeys.LANGUAGE.getData(dataContext);
    }

    @Nullable
    public static Project getProject(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            HandlerUtils.$$$reportNull$$$0(7);
        }
        return (Project)DataKeys.PROJECT.getData(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/HandlerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadOnly";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

