/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.NamedArgumentInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class MapArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> IN_ARGUMENT_LIST_OF_CALL = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrArgumentList.class), PlatformPatterns.psiElement(GrListOrMap.class)})));
    public static final ElementPattern<PsiElement> IN_LABEL = PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT).withParent(GrArgumentLabel.class);

    private MapArgumentCompletionProvider() {
    }

    public static void register(CompletionContributor contributor) {
        MapArgumentCompletionProvider instance = new MapArgumentCompletionProvider();
        contributor.extend(CompletionType.BASIC, IN_ARGUMENT_LIST_OF_CALL, (CompletionProvider)instance);
        contributor.extend(CompletionType.BASIC, IN_LABEL, (CompletionProvider)instance);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement mapOrArgumentList;
        if (parameters == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters)) == null) {
            return;
        }
        if (MapArgumentCompletionProvider.isMapKeyCompletion(parameters)) {
            result.stopHere();
        }
        HashMap map = ContainerUtil.newHashMap(MapArgumentCompletionProvider.calculateNamedArguments(mapOrArgumentList));
        for (GrNamedArgument argument : MapArgumentCompletionProvider.getSiblingNamedArguments(mapOrArgumentList)) {
            map.remove(argument.getLabelName());
        }
        for (Map.Entry entry : map.entrySet()) {
            LookupElementBuilder lookup = LookupElementBuilder.create(entry.getValue(), (String)((String)entry.getKey())).withInsertHandler((InsertHandler)NamedArgumentInsertHandler.INSTANCE).withTailText(":");
            lookup = ((NamedArgumentDescriptor)entry.getValue()).getPriority() == NamedArgumentDescriptor.Priority.UNLIKELY ? lookup.withItemTextForeground(GroovySyntaxHighlighter.MAP_KEY.getDefaultAttributes().getForegroundColor()) : lookup.withIcon(JetgroovyIcons.Groovy.DynamicProperty);
            LookupElement customized = ((NamedArgumentDescriptor)entry.getValue()).customizeLookupElement(lookup);
            result.addElement((LookupElement)(customized == null ? lookup : customized));
        }
    }

    public static boolean isMapKeyCompletion(CompletionParameters parameters) {
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters);
        return mapOrArgumentList instanceof GrListOrMap && ((GrListOrMap)mapOrArgumentList).getNamedArguments().length > 0;
    }

    @Nullable
    private static PsiElement findMapOrArgumentList(CompletionParameters parameters) {
        PsiElement parent = parameters.getPosition().getParent();
        if (parent instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)parent).getQualifier() != null) {
                return null;
            }
            return parent.getParent();
        }
        if (parent == null || parent.getParent() == null) {
            return null;
        }
        return parent.getParent().getParent();
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> findOtherNamedArgumentsInFile(PsiElement mapOrArgumentList) {
        final HashMap<String, NamedArgumentDescriptor> map = new HashMap<String, NamedArgumentDescriptor>();
        mapOrArgumentList.getContainingFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                String name;
                if (element instanceof GrArgumentLabel && GroovyNamesUtil.isIdentifier(name = ((GrArgumentLabel)element).getName())) {
                    map.put(name, NamedArgumentDescriptor.SIMPLE_UNLIKELY);
                }
                super.visitElement(element);
            }
        });
        HashMap<String, NamedArgumentDescriptor> hashMap = map;
        if (hashMap == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static GrNamedArgument[] getSiblingNamedArguments(PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList instanceof GrListOrMap) {
            return ((GrListOrMap)mapOrArgumentList).getNamedArguments();
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList && argumentList.getParent() instanceof GrCall) {
            return PsiUtil.getFirstMapNamedArguments((GrCall)argumentList.getParent());
        }
        return GrNamedArgument.EMPTY_ARRAY;
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> calculateNamedArguments(@NotNull PsiElement mapOrArgumentList) {
        Map<String, NamedArgumentDescriptor> map;
        if (mapOrArgumentList == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(3);
        }
        if (((map = MapArgumentCompletionProvider.calcNamedArgumentsForCall(mapOrArgumentList)) == null || map.isEmpty()) && mapOrArgumentList instanceof GrListOrMap) {
            map = NamedArgumentUtilKt.getDescriptors((GrListOrMap)mapOrArgumentList);
        }
        if (map == null || map.isEmpty()) {
            map = MapArgumentCompletionProvider.findOtherNamedArgumentsInFile(mapOrArgumentList);
        }
        Map<String, NamedArgumentDescriptor> map2 = map;
        if (map2 == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Nullable
    private static Map<String, NamedArgumentDescriptor> calcNamedArgumentsForCall(@NotNull PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList == null) {
            MapArgumentCompletionProvider.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList) {
            if (mapOrArgumentList instanceof GrListOrMap && (((GrArgumentList)argumentList).getNamedArguments().length > 0 || ((GrArgumentList)argumentList).getExpressionArgumentIndex((GrListOrMap)mapOrArgumentList) > 0)) {
                return Collections.emptyMap();
            }
            if (argumentList.getParent() instanceof GrCall) {
                return GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders((GrCall)argumentList.getParent(), null, true);
            }
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapOrArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOtherNamedArgumentsInFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateNamedArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateNamedArguments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcNamedArgumentsForCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

