/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrBuiltinTypeClassExpressionImpl
extends GrExpressionImpl
implements GrBuiltinTypeClassExpression {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types.GrBuiltinTypeClassExpressionImpl");
    private static final Function<GrBuiltinTypeClassExpressionImpl, PsiType> TYPES_CALCULATOR = new MyTypesCalculator();

    public GrBuiltinTypeClassExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrBuiltinTypeClassExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitBuiltinTypeClassExpression(this);
    }

    public String toString() {
        return "builtin type class expression";
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    @NotNull
    public PsiPrimitiveType getPrimitiveType() {
        PsiPrimitiveType psiPrimitiveType = TypesUtil.getPrimitiveTypeByText(this.getText());
        if (psiPrimitiveType == null) {
            GrBuiltinTypeClassExpressionImpl.$$$reportNull$$$0(1);
        }
        return psiPrimitiveType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrBuiltinTypeClassExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrBuiltinTypeClassExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTypesCalculator
    implements Function<GrBuiltinTypeClassExpressionImpl, PsiType> {
        private MyTypesCalculator() {
        }

        public PsiType fun(GrBuiltinTypeClassExpressionImpl expression) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiClass clazz = facade.findClass("java.lang.Class", expression.getResolveScope());
            if (clazz != null) {
                PsiElementFactory factory = facade.getElementFactory();
                PsiTypeParameter[] typeParameters = clazz.getTypeParameters();
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                if (typeParameters.length == 1) {
                    try {
                        PsiPrimitiveType type = expression.getPrimitiveType();
                        substitutor = substitutor.put(typeParameters[0], (PsiType)type);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return factory.createType(clazz, substitutor);
            }
            return null;
        }
    }
}

