/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrStubUtils {
    private static final Logger LOG = Logger.getInstance(GrStubUtils.class);
    public static final int TOO_LONG = -1;

    public static void writeStringArray(StubOutputStream dataStream, String[] array) throws IOException {
        if (array.length > 127) {
            dataStream.writeByte(-1);
            dataStream.writeInt(array.length);
        } else {
            dataStream.writeByte(array.length);
        }
        for (String s : array) {
            LOG.assertTrue(s != null);
            dataStream.writeName(s);
        }
    }

    public static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int length = dataStream.readByte();
        if (length == -1) {
            length = dataStream.readInt();
        }
        String[] annNames = new String[length];
        for (int i = 0; i < length; ++i) {
            annNames[i] = dataStream.readName().toString();
        }
        return annNames;
    }

    public static void writeNullableString(StubOutputStream dataStream, @Nullable String typeText) throws IOException {
        DataInputOutputUtil.writeNullable((DataOutput)dataStream, (Object)typeText, s -> dataStream.writeUTFFast(s));
    }

    @Nullable
    public static String readNullableString(StubInputStream dataStream) throws IOException {
        return (String)DataInputOutputUtil.readNullable((DataInput)dataStream, () -> dataStream.readUTFFast());
    }

    @Nullable
    public static String getTypeText(@Nullable GrTypeElement typeElement) {
        return typeElement == null ? null : typeElement.getText();
    }

    @NotNull
    private static Map<String, String> getAliasMapping(@Nullable PsiFile file) {
        if (!(file instanceof GroovyFile)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                GrStubUtils.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            HashMap mapping = ContainerUtil.newHashMap();
            for (GrImportStatement importStatement : ((GroovyFile)file).getImportStatements()) {
                if (importStatement.getImportReference() == null || importStatement.isStatic() || !importStatement.isAliasedImport()) continue;
                String importName = importStatement.getImportReference().getClassNameText();
                String importedName = importStatement.getImportedName();
                if (importedName == null) continue;
                mapping.put(importedName, importName);
            }
            return CachedValueProvider.Result.create((Object)mapping, (Object[])new Object[]{file});
        });
        if (map == null) {
            GrStubUtils.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public static String getReferenceName(@NotNull GrReferenceElement element) {
        String referenceName;
        if (element == null) {
            GrStubUtils.$$$reportNull$$$0(2);
        }
        if ((referenceName = element.getReferenceName()) == null) {
            return null;
        }
        String mappedFqn = GrStubUtils.getAliasMapping(element.getContainingFile()).get(referenceName);
        String fullText = element.getText();
        return mappedFqn == null || element.isQualified() ? fullText : fullText.replace(referenceName, mappedFqn);
    }

    @Nullable
    public static String getBaseClassName(@NotNull GrTypeDefinition psi) {
        if (psi == null) {
            GrStubUtils.$$$reportNull$$$0(3);
        }
        if (!(psi instanceof GrAnonymousClassDefinition)) {
            return null;
        }
        return GrStubUtils.getReferenceName(((GrAnonymousClassDefinition)psi).getBaseClassReferenceGroovy());
    }

    public static String[] getAnnotationNames(PsiModifierListOwner psi) {
        ArrayList annoNames = ContainerUtil.newArrayList();
        PsiModifierList modifierList = psi.getModifierList();
        if (modifierList instanceof GrModifierList) {
            for (GrAnnotation annotation : ((GrModifierList)modifierList).getRawAnnotations()) {
                String name = annotation.getShortName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                annoNames.add(name);
            }
        }
        return ArrayUtil.toStringArray((Collection)annoNames);
    }

    public static boolean isGroovyStaticMemberStub(StubElement<?> stub) {
        StubElement classStub;
        StubElement modifierOwner = stub instanceof GrMethodStub ? stub : stub.getParentStub();
        StubElement type = modifierOwner.findChildStubByType(GroovyElementTypes.MODIFIERS);
        if (!(type instanceof GrModifierListStub)) {
            return false;
        }
        int mask = ((GrModifierListStub)type).getModifiersFlags();
        if (GrModifierListUtil.hasMaskModifier(mask, "private")) {
            return false;
        }
        if (GrModifierListUtil.hasMaskModifier(mask, "static")) {
            return true;
        }
        StubElement parent = modifierOwner.getParentStub();
        StubElement stubElement = classStub = parent == null ? null : parent.getParentStub();
        return classStub instanceof GrTypeDefinitionStub && (((GrTypeDefinitionStub)classStub).isAnnotationType() || ((GrTypeDefinitionStub)classStub).isInterface());
    }

    @NotNull
    public static String getShortTypeText(@Nullable String text) {
        if (text == null) {
            if ("" == null) {
                GrStubUtils.$$$reportNull$$$0(4);
            }
            return "";
        }
        int i = text.length();
        while (i - 2 >= 0 && text.charAt(i - 2) == '[' && text.charAt(i - 1) == ']') {
            i -= 2;
        }
        String string = PsiNameHelper.getShortClassName((String)text.substring(0, i)) + text.substring(i);
        if (string == null) {
            GrStubUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getPackageName(GrFileStub stub) {
        for (StubElement child : stub.getChildrenStubs()) {
            if (!(child instanceof GrPackageDefinitionStub)) continue;
            return ((GrPackageDefinitionStub)child).getPackageName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrStubUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasMapping";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrStubUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

