/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class SetterWriter {
    private static final Logger LOG = Logger.getInstance(SetterWriter.class);
    private final StringBuilder myBuffer;
    private final PsiClass myClass;
    private final PsiMethod mySetter;
    private final String myName;
    private final ClassNameProvider myClassNameProvider;
    private final ExpressionContext myContext;

    public SetterWriter(@NotNull StringBuilder builder, @NotNull PsiClass psiClass, @NotNull PsiMethod setter, @NotNull String name, @NotNull ClassNameProvider classNameProvider, @NotNull ExpressionContext context) {
        if (builder == null) {
            SetterWriter.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SetterWriter.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            SetterWriter.$$$reportNull$$$0(2);
        }
        if (name == null) {
            SetterWriter.$$$reportNull$$$0(3);
        }
        if (classNameProvider == null) {
            SetterWriter.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SetterWriter.$$$reportNull$$$0(5);
        }
        this.myBuffer = builder;
        this.myClass = psiClass;
        this.myClassNameProvider = classNameProvider;
        this.myContext = context;
        this.myName = name;
        if (setter instanceof PsiCompiledElement) {
            setter = (PsiMethod)((PsiCompiledElement)setter).getMirror();
        }
        this.mySetter = setter;
    }

    public void write() {
        boolean isStatic = this.mySetter.hasModifierProperty("static");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.project);
        PsiParameter[] parameters = this.mySetter.getParameterList().getParameters();
        PsiParameter parameter = parameters[parameters.length - 1];
        PsiType parameterType = this.myContext.typeProvider.getParameterType(parameter);
        this.myBuffer.append("private static ");
        this.processTypeParameters(parameterType);
        this.myBuffer.append(this.myName);
        if (!(parameterType instanceof PsiPrimitiveType)) {
            parameter = factory.createParameter(parameter.getName(), "Value", null);
        }
        PsiParameter[] actual = this.inferActualParameters(isStatic, parameters, parameter);
        GroovyPsiElement place = this.createStubMethod(actual);
        GenerationUtil.writeParameterList(this.myBuffer, actual, this.myClassNameProvider, this.myContext);
        this.writeBody(isStatic, parameters, parameter, place);
    }

    private void writeBody(boolean aStatic, @NotNull PsiParameter[] parameters, @NotNull PsiParameter parameter, GroovyPsiElement place) {
        if (parameters == null) {
            SetterWriter.$$$reportNull$$$0(6);
        }
        if (parameter == null) {
            SetterWriter.$$$reportNull$$$0(7);
        }
        this.myBuffer.append("{\n");
        this.myContext.myUsedVarNames.add("propOwner");
        GrExpression[] args = this.generateArguments(parameters, place);
        new ExpressionGenerator(this.myBuffer, this.myContext).invokeMethodOn(this.mySetter, aStatic ? null : GroovyPsiElementFactory.getInstance(this.myContext.project).createExpressionFromText("propOwner", place), args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, place);
        this.myBuffer.append(";\n");
        this.myBuffer.append("return ").append(parameter.getName()).append(";\n");
        this.myBuffer.append("}\n");
    }

    @NotNull
    private GrExpression[] generateArguments(@NotNull PsiParameter[] parameters, @NotNull GroovyPsiElement place) {
        if (parameters == null) {
            SetterWriter.$$$reportNull$$$0(8);
        }
        if (place == null) {
            SetterWriter.$$$reportNull$$$0(9);
        }
        GrExpression[] args = new GrExpression[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            args[i] = GroovyPsiElementFactory.getInstance(this.myContext.project).createExpressionFromText(parameters[i].getName(), place);
            this.myContext.myUsedVarNames.add(parameters[i].getName());
        }
        if (args == null) {
            SetterWriter.$$$reportNull$$$0(10);
        }
        return args;
    }

    private GroovyPsiElement createStubMethod(@NotNull PsiParameter[] parameters) {
        if (parameters == null) {
            SetterWriter.$$$reportNull$$$0(11);
        }
        StringBuilder methodText = new StringBuilder("def ").append(this.myName).append('(');
        for (PsiParameter parameter : parameters) {
            methodText.append(parameter.getType().getCanonicalText()).append(' ').append(parameter.getName()).append(',');
        }
        if (parameters.length > 0) {
            methodText.deleteCharAt(methodText.length() - 1);
        }
        methodText.append("){}");
        return GroovyPsiElementFactory.getInstance(this.myContext.project).createMethodFromText(methodText.toString(), (PsiElement)this.mySetter);
    }

    @NotNull
    private PsiParameter[] inferActualParameters(boolean aStatic, @NotNull PsiParameter[] parameters, @NotNull PsiParameter parameter) {
        PsiParameter[] actual;
        if (parameters == null) {
            SetterWriter.$$$reportNull$$$0(12);
        }
        if (parameter == null) {
            SetterWriter.$$$reportNull$$$0(13);
        }
        parameters[parameters.length - 1] = parameter;
        if (aStatic) {
            actual = parameters;
        } else {
            PsiClass containingClass = this.mySetter.getContainingClass();
            String typeText = containingClass == null ? (this.mySetter instanceof GrGdkMethod ? ((GrGdkMethod)this.mySetter).getStaticMethod().getParameterList().getParameters()[0].getType().getCanonicalText() : "java.lang.Object") : containingClass.getQualifiedName();
            GrParameter propOwner = GroovyPsiElementFactory.getInstance(this.myContext.project).createParameter("propOwner", typeText, null);
            actual = new PsiParameter[parameters.length + 1];
            actual[0] = propOwner;
            System.arraycopy(parameters, 0, actual, 1, parameters.length);
        }
        if (actual == null) {
            SetterWriter.$$$reportNull$$$0(14);
        }
        return actual;
    }

    private void processTypeParameters(PsiType parameterType) {
        if (this.mySetter.hasTypeParameters()) {
            GenerationUtil.writeTypeParameters(this.myBuffer, (PsiTypeParameterListOwner)this.mySetter, this.myClassNameProvider);
        }
        if (parameterType instanceof PsiPrimitiveType) {
            this.myBuffer.append(parameterType.getCanonicalText()).append(' ');
        } else {
            if (this.mySetter.hasTypeParameters()) {
                this.myBuffer.delete(this.myBuffer.length() - 1, this.myBuffer.length());
                this.myBuffer.append(", ");
            } else {
                this.myBuffer.append('<');
            }
            this.myBuffer.append("Value");
            if (!parameterType.equalsToText("java.lang.Object")) {
                this.myBuffer.append(" extends ");
                TypeWriter.writeType(this.myBuffer, parameterType, (PsiElement)this.myClass, this.myClassNameProvider);
            }
            this.myBuffer.append('>');
            this.myBuffer.append("Value ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/SetterWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/SetterWriter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateArguments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferActualParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeBody";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateArguments";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStubMethod";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inferActualParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

