/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.model.enums.AccessType;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmEmbeddedAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.model.xml.mapping.HbmPersistentObjectBase;
import com.intellij.hibernate.model.xml.mapping.HbmProperty;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.converters.AbstractMemberResolveConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeMemberConverter
extends AbstractMemberResolveConverter {
    protected String getPropertyName(String s, ConvertContext context) {
        return super.getPropertyName(s != null && s.length() > 0 && Character.isUpperCase(s.charAt(0)) && !(context.getInvocationElement() instanceof HbmProperty) ? StringUtil.decapitalize((String)s) : s, context);
    }

    protected boolean methodSuits(PsiMethod psiMethod) {
        return PropertyUtil.isSimplePropertyGetter((PsiMethod)psiMethod) && !psiMethod.hasModifierProperty("final") && super.methodSuits(psiMethod);
    }

    protected boolean fieldSuits(PsiField psiField) {
        return !psiField.hasModifierProperty("final") && !psiField.hasModifierProperty("transient") && super.fieldSuits(psiField);
    }

    @Nullable
    protected PsiClass getTargetClass(ConvertContext context) {
        DomElement cur;
        DomElement parent = context.getInvocationElement().getParent();
        DomElement domElement = cur = parent instanceof PersistentAttribute ? parent.getParent() : parent;
        while (cur != null) {
            if (cur instanceof HbmPersistentObjectBase) {
                return (PsiClass)((HbmPersistentObjectBase)cur).getClazz().getValue();
            }
            if (cur instanceof HbmEmbeddedAttributeBase && (!(cur instanceof HbmCompositeId) || HibernateUtil.isEmbedded((HbmCompositeId)cur))) {
                return PersistenceCommonUtil.getTargetClass((PersistentEmbeddedAttribute)((PersistentEmbeddedAttribute)cur));
            }
            cur = cur.getParent();
        }
        return null;
    }

    @NotNull
    protected PropertyMemberType[] getMemberTypes(ConvertContext context) {
        AccessType type;
        HbmContainer container;
        PersistentAttribute attributeBase = (PersistentAttribute)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), PersistentAttribute.class, (boolean)false);
        HbmContainer hbmContainer = container = attributeBase != null ? null : (HbmContainer)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), HbmContainer.class, (boolean)false);
        boolean isField = attributeBase != null ? attributeBase.getAttributeModelHelper().isFieldAccess() : (container != null ? (type = (AccessType)((Object)container.getAccess().getValue())) == AccessType.FIELD || type == null && AttributeMemberConverter.isDefaultAccessField((DomElement)container) : false);
        PropertyMemberType[] propertyMemberTypeArray = new PropertyMemberType[1];
        PropertyMemberType propertyMemberType = propertyMemberTypeArray[0] = isField ? PropertyMemberType.FIELD : PropertyMemberType.GETTER;
        if (propertyMemberTypeArray == null) {
            AttributeMemberConverter.$$$reportNull$$$0(0);
        }
        return propertyMemberTypeArray;
    }

    @NotNull
    protected PsiType getPsiType(ConvertContext context) {
        DomElement invocationElement = context.getInvocationElement();
        DomElement parent = invocationElement.getParent();
        Object attributeBase = parent instanceof HbmAttributeBase ? (PersistentAttribute)parent : (parent instanceof HbmContainer ? ((HbmContainer)parent).getContainedAttribute() : null);
        if (attributeBase == null) {
            PsiType psiType = super.getPsiType(context);
            if (psiType == null) {
                AttributeMemberConverter.$$$reportNull$$$0(1);
            }
            return psiType;
        }
        PsiType psiType = JpaUtil.getAttributeTypeOrDefault((PersistentAttribute)attributeBase);
        if (psiType == null) {
            AttributeMemberConverter.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    public static boolean isDefaultAccessField(DomElement element) {
        HbmHibernateMapping mapping = (HbmHibernateMapping)element.getParentOfType(HbmHibernateMapping.class, false);
        return mapping != null && mapping.getDefaultAccess().getValue() == AccessType.FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/hibernate/model/converters/AttributeMemberConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

