/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.OptionGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class IndentOptionsEditor
extends OptionGroup {
    protected JTextField myIndentField;
    protected JCheckBox myCbUseTab;
    protected JTextField myTabSizeField;
    protected JLabel myTabSizeLabel;
    protected JLabel myIndentLabel;

    @Override
    public JPanel createPanel() {
        this.addComponents();
        JPanel result = super.createPanel();
        return result;
    }

    protected void addComponents() {
        this.addTabOptions();
        this.myTabSizeField = this.createIndentTextField();
        this.myTabSizeLabel = new JLabel(ApplicationBundle.message("editbox.indent.tab.size", new Object[0]));
        this.add((JComponent)this.myTabSizeLabel, this.myTabSizeField);
        this.myIndentField = this.createIndentTextField();
        this.myIndentLabel = new JLabel(ApplicationBundle.message("editbox.indent.indent", new Object[0]));
        this.add((JComponent)this.myIndentLabel, this.myIndentField);
    }

    protected JTextField createIndentTextField() {
        JTextField field = new JTextField(4);
        field.setMinimumSize(field.getPreferredSize());
        return field;
    }

    protected void addTabOptions() {
        this.myCbUseTab = new JCheckBox(ApplicationBundle.message("checkbox.indent.use.tab.character", new Object[0]));
        this.add(this.myCbUseTab);
    }

    protected static boolean isFieldModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    protected static boolean isFieldModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected int getFieldValue(JTextField field, int minValue, int defValue) {
        try {
            return Math.max(Integer.parseInt(field.getText()), minValue);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = IndentOptionsEditor.isFieldModified(this.myTabSizeField, options.TAB_SIZE);
        isModified |= IndentOptionsEditor.isFieldModified(this.myCbUseTab, options.USE_TAB_CHARACTER);
        return isModified |= IndentOptionsEditor.isFieldModified(this.myIndentField, options.INDENT_SIZE);
    }

    protected int getUIIndent() {
        return this.getFieldValue(this.myIndentField, 0, 4);
    }

    protected int getUITabSize() {
        return this.getFieldValue(this.myTabSizeField, 1, 4);
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        options.INDENT_SIZE = this.getUIIndent();
        options.TAB_SIZE = this.getUITabSize();
        options.USE_TAB_CHARACTER = this.myCbUseTab.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            IndentOptionsEditor.$$$reportNull$$$0(0);
        }
        if (options == null) {
            IndentOptionsEditor.$$$reportNull$$$0(1);
        }
        this.myTabSizeField.setText(String.valueOf(options.TAB_SIZE));
        this.myCbUseTab.setSelected(options.USE_TAB_CHARACTER);
        this.myIndentField.setText(String.valueOf(options.INDENT_SIZE));
    }

    public void setEnabled(boolean enabled) {
        this.myIndentField.setEnabled(enabled);
        this.myIndentLabel.setEnabled(enabled);
        this.myTabSizeField.setEnabled(enabled);
        this.myTabSizeLabel.setEnabled(enabled);
        this.myCbUseTab.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/IndentOptionsEditor";
        objectArray[2] = "reset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

