/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogFilterModel {
    private Pattern myCustomPattern;

    public void updateCustomFilter(String filter) {
        this.myCustomPattern = null;
    }

    public abstract String getCustomFilter();

    @Nullable
    private Pattern getCustomPattern() {
        String customFilter = this.getCustomFilter();
        if (this.myCustomPattern == null && customFilter != null) {
            StringBuilder buf = new StringBuilder(customFilter.length());
            for (int i2 = 0; i2 < customFilter.length(); ++i2) {
                char c = customFilter.charAt(i2);
                if (Character.isLetterOrDigit(c)) {
                    buf.append(Character.toUpperCase(c));
                    continue;
                }
                buf.append("\\").append(c);
            }
            this.myCustomPattern = Pattern.compile(".*" + buf + ".*", 32);
        }
        return this.myCustomPattern;
    }

    public abstract void addFilterListener(LogFilterListener var1);

    public abstract void removeFilterListener(LogFilterListener var1);

    public boolean isApplicable(String line) {
        Pattern pattern;
        return this.getCustomFilter() == null || (pattern = this.getCustomPattern()) == null || pattern.matcher(StringUtil.toUpperCase((String)line)).matches();
    }

    public abstract List<? extends LogFilter> getLogFilters();

    public abstract boolean isFilterSelected(LogFilter var1);

    public abstract void selectFilter(LogFilter var1);

    @NotNull
    public abstract MyProcessingResult processLine(String var1);

    public void processingStarted() {
    }

    public static class MyProcessingResult {
        private final Key myKey;
        private final boolean myApplicable;
        private final String myMessagePrefix;

        public MyProcessingResult(@Nullable Key key, boolean applicable, @Nullable String messagePrefix) {
            this.myKey = key;
            this.myApplicable = applicable;
            this.myMessagePrefix = messagePrefix;
        }

        @Nullable
        public Key getKey() {
            return this.myKey;
        }

        public boolean isApplicable() {
            return this.myApplicable;
        }

        @Nullable
        public String getMessagePrefix() {
            return this.myMessagePrefix;
        }
    }
}

