/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import javax.swing.Icon;

public class DashboardRunConfigurationStatus {
    public static final DashboardRunConfigurationStatus STARTED = new DashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.started.group.name", new Object[0]), AllIcons.Toolwindows.ToolWindowRun);
    public static final DashboardRunConfigurationStatus STOPPED = new DashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.stopped.group.name", new Object[0]), AllIcons.Actions.Suspend);
    public static final DashboardRunConfigurationStatus FAILED = new DashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.failed.group.name", new Object[0]), AllIcons.General.Error);
    private final String myName;
    private final Icon myIcon;

    public DashboardRunConfigurationStatus(String name, Icon icon) {
        this.myName = name;
        this.myIcon = icon;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public static DashboardRunConfigurationStatus getStatus(DashboardRunConfigurationNode node) {
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor == null) {
            return STOPPED;
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler == null) {
            return STOPPED;
        }
        Integer exitCode = processHandler.getExitCode();
        if (exitCode == null) {
            return STARTED;
        }
        Boolean terminationRequested = (Boolean)processHandler.getUserData(ProcessHandler.TERMINATION_REQUESTED);
        if (exitCode == 0 || terminationRequested != null && terminationRequested.booleanValue()) {
            return STOPPED;
        }
        return FAILED;
    }
}

