/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionExFilterFactory
implements ExceptionFilterFactory {
    @Override
    @NotNull
    public Filter create(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(0);
        }
        MyFilter myFilter = new MyFilter(searchScope);
        if (myFilter == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(1);
        }
        return myFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionExFilterFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionExFilterFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFilter
    implements Filter,
    FilterMixin {
        private final ExceptionInfoCache myCache;

        public MyFilter(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myCache = new ExceptionInfoCache(scope);
        }

        @Override
        public Filter.Result applyFilter(String line, int textEndOffset) {
            return null;
        }

        @Override
        public boolean shouldRunHeavy() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<FilterMixin.AdditionalHighlight> consumer) {
            if (copiedFragment == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                MyFilter.$$$reportNull$$$0(2);
            }
            THashMap visited = new THashMap();
            Trinity emptyInfo = Trinity.create(null, null, null);
            ExceptionWorker worker = new ExceptionWorker(this.myCache);
            for (int i2 = 0; i2 < copiedFragment.getLineCount(); ++i2) {
                Trinity<TextRange, TextRange, TextRange> info;
                int lineEndOffset;
                int lineStartOffset = copiedFragment.getLineStartOffset(i2);
                String lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset = copiedFragment.getLineEndOffset(i2)));
                if (!lineText.contains(".java:") || (info = (Trinity<TextRange, TextRange, TextRange>)visited.get(lineText)) == emptyInfo) continue;
                if (info == null) {
                    info = emptyInfo;
                    AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                    try {
                        PsiCodeBlock tryBlock;
                        int offset;
                        PsiFile psiFile;
                        OpenFileDescriptor descriptor;
                        HyperlinkInfo hyperlinkInfo;
                        Filter.Result result = worker.execute(lineText, lineEndOffset);
                        if (result == null || !((hyperlinkInfo = result.getHyperlinkInfo()) instanceof FileHyperlinkInfo) || (descriptor = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor()) == null || (psiFile = worker.getFile()) == null || psiFile instanceof PsiCompiledFile || (offset = descriptor.getOffset()) <= 0) continue;
                        PsiElement element = psiFile.findElementAt(offset);
                        PsiTryStatement parent = PsiTreeUtil.getParentOfType(element, PsiTryStatement.class, true, PsiClass.class);
                        PsiCodeBlock psiCodeBlock = tryBlock = parent != null ? parent.getTryBlock() : null;
                        if (tryBlock == null || !tryBlock.getTextRange().contains(offset)) continue;
                        info = worker.getInfo();
                    }
                    finally {
                        token.finish();
                        visited.put(lineText, info);
                    }
                }
                int off = startOffset + lineStartOffset;
                final Color color = UIUtil.getInactiveTextColor();
                consumer.consume((Object)new FilterMixin.AdditionalHighlight(off + ((TextRange)info.first).getStartOffset(), off + ((TextRange)info.second).getEndOffset()){

                    @Override
                    @NotNull
                    public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
                        TextAttributes textAttributes = new TextAttributes(null, null, color, EffectType.BOLD_DOTTED_LINE, 0);
                        if (textAttributes == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return textAttributes;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter$1", "getTextAttributes"));
                    }
                });
            }
        }

        @Override
        @NotNull
        public String getUpdateMessage() {
            if ("Highlighting try blocks..." == null) {
                MyFilter.$$$reportNull$$$0(3);
            }
            return "Highlighting try blocks...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiedFragment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdateMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyHeavyFilter";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

