/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/filters/FileHyperlinkInfoBase;", "Lcom/intellij/execution/filters/FileHyperlinkInfo;", "myProject", "Lcom/intellij/openapi/project/Project;", "myDocumentLine", "", "myDocumentColumn", "(Lcom/intellij/openapi/project/Project;II)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "calculateOffset", "document", "Lcom/intellij/openapi/editor/Document;", "documentLine", "documentColumn", "(Lcom/intellij/openapi/editor/Document;II)Ljava/lang/Integer;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "navigate", "", "project", "lang-api"})
public abstract class FileHyperlinkInfoBase
implements FileHyperlinkInfo {
    private final Project myProject;
    private final int myDocumentLine;
    private final int myDocumentColumn;

    @Nullable
    protected abstract VirtualFile getVirtualFile();

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        file = this.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(file);
        v0 = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
        if (v0 == null) ** GOTO lbl-1000
        var4_3 = v0;
        mapping = var4_3;
        mappingLine = mapping.bytecodeToSource(this.myDocumentLine + 1) - 1;
        v1 = mappingLine < 0 ? null : Integer.valueOf(mappingLine);
        v0 = v1;
        if (v1 != null) {
            v2 = v0.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.myDocumentLine;
        }
        line = v2;
        offset = this.calculateOffset(document, line, this.myDocumentColumn);
        if (offset == null) {
            return new OpenFileDescriptor(this.myProject, file, line, this.myDocumentColumn);
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public void navigate(@Nullable Project project) {
        block1: {
            OpenFileDescriptor openFileDescriptor;
            if (project == null) {
                return;
            }
            OpenFileDescriptor openFileDescriptor2 = this.getDescriptor();
            if (openFileDescriptor2 == null) break block1;
            OpenFileDescriptor it = openFileDescriptor = openFileDescriptor2;
            FileEditorManager.getInstance(project).openTextEditor(it, true);
        }
    }

    @Nullable
    protected Integer calculateOffset(@Nullable Document document, int documentLine, int documentColumn) {
        if (document == null) {
            return null;
        }
        if (documentLine < 0 || document.getLineCount() <= documentLine) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(documentLine);
        int lineEndOffset = document.getLineEndOffset(documentLine);
        int fixedColumn = Math.min(Math.max(documentColumn, 0), lineEndOffset - lineStartOffset);
        return lineStartOffset + fixedColumn;
    }

    public FileHyperlinkInfoBase(@NotNull Project myProject, int myDocumentLine, int myDocumentColumn) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myDocumentLine = myDocumentLine;
        this.myDocumentColumn = myDocumentColumn;
    }
}

