/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    public static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private boolean myHasErrorStream;
    private boolean myHasPty;
    private boolean myDestroyRecursively;
    private Set<File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(0);
        }
        this(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
    }

    @Deprecated
    public OSProcessHandler(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(1);
        }
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(2);
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(3);
        }
        super(process, commandLine, charset);
        this.myHasErrorStream = true;
        this.myDestroyRecursively = true;
        this.myFilesToDelete = null;
        this.setHasPty(OSProcessHandler.isPtyProcess(process));
    }

    private static boolean isPtyProcess(Process process) {
        for (Class<?> c = process.getClass(); c != null; c = c.getSuperclass()) {
            if (!"com.pty4j.unix.UnixPtyProcess".equals(c.getName()) && !"com.pty4j.windows.WinPtyProcess".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            OSProcessHandler.$$$reportNull$$$0(4);
        }
        Future future = super.executeOnPooledThread(task);
        if (future == null) {
            OSProcessHandler.$$$reportNull$$$0(5);
        }
        return future;
    }

    protected void onOSProcessTerminated(int exitCode) {
        super.onOSProcessTerminated(exitCode);
        if (this.myFilesToDelete != null) {
            for (File file : this.myFilesToDelete) {
                FileUtil.delete((File)file);
            }
        }
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process);
        } else {
            this.executeOnPooledThread(() -> {
                if (process == null) {
                    OSProcessHandler.$$$reportNull$$$0(9);
                }
                this.killProcessTreeSync(process);
            });
        }
    }

    private void killProcessTreeSync(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(7);
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            if (!process.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process.destroy();
            }
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.myHasPty ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
        if (options == null) {
            OSProcessHandler.$$$reportNull$$$0(8);
        }
        return options;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTreeSync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$killProcessTree$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

