/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.jam.JamElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommonModelElement {
    public boolean isValid();

    public XmlTag getXmlTag();

    public PsiManager getPsiManager();

    @Nullable
    public Module getModule();

    @Nullable
    public PsiElement getIdentifyingPsiElement();

    @Nullable
    public PsiFile getContainingFile();

    public static interface CommonModelNewJamElement
    extends CommonModelElement,
    JamElement {
    }

    public static abstract class ModuleBase
    implements CommonModelElement {
        @Override
        @NotNull
        public abstract Module getModule();

        @Override
        public boolean isValid() {
            return !this.getModule().isDisposed();
        }

        @Override
        @Nullable
        public XmlTag getXmlTag() {
            return null;
        }

        @Override
        public PsiManager getPsiManager() {
            return PsiManager.getInstance(this.getModule().getProject());
        }

        @Override
        public PsiElement getIdentifyingPsiElement() {
            return null;
        }

        @Override
        public PsiFile getContainingFile() {
            return null;
        }
    }

    public static abstract class PsiBase
    implements CommonModelElement {
        @NotNull
        public abstract PsiElement getPsiElement();

        @Override
        public boolean isValid() {
            return this.getPsiElement().isValid();
        }

        @Override
        @Nullable
        public XmlTag getXmlTag() {
            return null;
        }

        @Override
        public PsiManager getPsiManager() {
            return this.getPsiElement().getManager();
        }

        @Override
        public Module getModule() {
            return this.isValid() ? ModuleUtilCore.findModuleForPsiElement(this.getPsiElement()) : null;
        }

        @Override
        public PsiElement getIdentifyingPsiElement() {
            return this.getPsiElement();
        }

        @Override
        public PsiFile getContainingFile() {
            return this.getPsiElement().getContainingFile();
        }
    }
}

