/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PausesStat;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.ex.ActionUtil");
    @NonNls
    private static final String WAS_ENABLED_BEFORE_DUMB = "WAS_ENABLED_BEFORE_DUMB";
    @NonNls
    public static final String WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = "WOULD_BE_ENABLED_IF_NOT_DUMB_MODE";
    @NonNls
    private static final String WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = "WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE";
    private static int insidePerformDumbAwareUpdate;

    private ActionUtil() {
    }

    public static void showDumbModeWarning(AnActionEvent ... events) {
        if (events == null) {
            ActionUtil.$$$reportNull$$$0(0);
        }
        Project project = null;
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            Project _project;
            String s = event.getPresentation().getText();
            if (StringUtil.isNotEmpty((String)s)) {
                actionNames.add(s);
            }
            if ((_project = event.getProject()) == null || project != null) continue;
            project = _project;
        }
        if (project == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Showing dumb mode warning for " + Arrays.asList(events), new Throwable());
        }
        DumbService.getInstance(project).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        if (actionNames == null) {
            ActionUtil.$$$reportNull$$$0(1);
        }
        String beAvailableUntil = " available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        String message = actionNames.isEmpty() ? "This action is not" + beAvailableUntil : (actionNames.size() == 1 ? "'" + actionNames.get(0) + "' action is not" + beAvailableUntil : "None of the following actions are" + beAvailableUntil + ": " + StringUtil.join(actionNames, (String)", "));
        String string = message;
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getUnavailableMessage(@NotNull String action, boolean plural) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(3);
        }
        String string = action + (plural ? " are" : " is") + " not available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(5);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(6);
        }
        Presentation presentation = e.getPresentation();
        Boolean wasEnabledBefore = (Boolean)presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean notAllowed = dumbMode && !action.isDumbAware() || Registry.is((String)"actionSystem.honor.modal.context") && isInModalContext && !action.isEnabledInModalContext();
        String description = presentation.getText() + " action update (" + action.getClass() + ")";
        if (insidePerformDumbAwareUpdate++ == 0) {
            ActionPauses.STAT.started(description);
        }
        try {
            if (beforeActionPerformed) {
                action.beforeActionPerformedUpdate(e);
            } else {
                action.update(e);
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, notAllowed && presentation.isEnabled());
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, notAllowed && presentation.isVisible());
        }
        catch (IndexNotReadyException e1) {
            if (notAllowed) {
                boolean bl = true;
                return bl;
            }
            throw e1;
        }
        finally {
            if (--insidePerformDumbAwareUpdate == 0) {
                ActionPauses.STAT.finished(description);
            }
            if (notAllowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean performDumbAwareUpdate(@NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(8);
        }
        return ActionUtil.performDumbAwareUpdate(false, action, e, beforeActionPerformed);
    }

    public static boolean isDumbMode(@Nullable Project project) {
        if (project != null) {
            return DumbService.getInstance(project).isDumb();
        }
        for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(proj).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(AnAction action, AnActionEvent e, boolean visibilityMatters) {
        ActionUtil.performDumbAwareUpdate(false, action, e, true);
        Project project = e.getProject();
        if (project != null && DumbService.getInstance(project).isDumb() && !action.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    public static void performActionDumbAware(final AnAction action, final AnActionEvent e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    action.actionPerformed(e);
                }
                catch (IndexNotReadyException ex) {
                    LOG.info((Throwable)ex);
                    ActionUtil.showDumbModeWarning(e);
                }
            }

            public String toString() {
                return action + " of " + action.getClass();
            }
        };
        if (action.startInTransaction()) {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.notNullize((List)((List)UIUtil.getClientProperty((Object)component, AnAction.ACTIONS_KEY)));
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static void clearActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(11);
        }
        UIUtil.putClientProperty((JComponent)component, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        if (to == null) {
            ActionUtil.$$$reportNull$$$0(12);
        }
        if (from == null) {
            ActionUtil.$$$reportNull$$$0(13);
        }
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component, @NotNull ActionListener action, @NotNull ShortcutSet shortcuts) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(14);
        }
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(15);
        }
        if (shortcuts == null) {
            ActionUtil.$$$reportNull$$$0(16);
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component.registerKeyboardAction(action, first, 2);
        }
    }

    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(17);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(18);
        }
        for (AnAction action : group.getChildren(null)) {
            if (action instanceof ActionGroup) {
                ActionUtil.recursiveRegisterShortcutSet((ActionGroup)action, component, parentDisposable);
            }
            action.registerCustomShortcutSet(component, parentDisposable);
        }
    }

    public static AnAction copyFrom(@NotNull AnAction action, @NotNull String actionId) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(19);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(20);
        }
        action.copyFrom(ActionManager.getInstance().getAction(actionId));
        return action;
    }

    public static AnAction mergeFrom(@NotNull AnAction action, @NotNull String actionId) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(21);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(22);
        }
        AnAction a1 = action;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getIcon(), (Object)p2.getIcon()));
        p1.setDisabledIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getDisabledIcon(), (Object)p2.getDisabledIcon()));
        p1.setSelectedIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getSelectedIcon(), (Object)p2.getSelectedIcon()));
        p1.setHoveredIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()));
        if (StringUtil.isEmpty((String)p1.getText())) {
            p1.setText(p2.getTextWithMnemonic(), p2.getDisplayedMnemonicIndex() >= 0);
        }
        p1.setDescription((String)ObjectUtils.chooseNotNull((Object)p1.getDescription(), (Object)p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == null || ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        return a1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeWarning";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnavailableMessage";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performDumbAwareUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearActions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyRegisteredShortcuts";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerForEveryKeyboardShortcut";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "recursiveRegisterShortcutSet";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionPauses {
        public static final PausesStat STAT = new PausesStat("AnAction.update()");
    }
}

