/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataNode<T>
implements Serializable,
UserDataHolderEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(DataNode.class);
    @NotNull
    private final List<DataNode<?>> myChildren;
    @NotNull
    private transient List<DataNode<?>> myChildrenView;
    @NotNull
    private transient UserDataHolderBase myUserData;
    @NotNull
    private final Key<T> myKey;
    private transient T myData;
    private byte[] myRawData;
    private boolean myIgnored;
    @Nullable
    private DataNode<?> myParent;

    public DataNode(@NotNull Key<T> key, @NotNull T data, @Nullable DataNode<?> parent) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(0);
        }
        if (data == null) {
            DataNode.$$$reportNull$$$0(1);
        }
        this.myChildren = ContainerUtilRt.newArrayList();
        this.myChildrenView = Collections.unmodifiableList(this.myChildren);
        this.myUserData = new UserDataHolderBase();
        this.myKey = key;
        this.myData = data;
        this.myParent = parent;
    }

    private DataNode(@NotNull Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(2);
        }
        this.myChildren = ContainerUtilRt.newArrayList();
        this.myChildrenView = Collections.unmodifiableList(this.myChildren);
        this.myUserData = new UserDataHolderBase();
        this.myKey = key;
    }

    @Nullable
    public DataNode<?> getParent() {
        return this.myParent;
    }

    @NotNull
    public <T> DataNode<T> createChild(@NotNull Key<T> key, @NotNull T data) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(3);
        }
        if (data == null) {
            DataNode.$$$reportNull$$$0(4);
        }
        DataNode<T> result = new DataNode<T>(key, data, this);
        this.myChildren.add(result);
        DataNode<T> dataNode = result;
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(5);
        }
        return dataNode;
    }

    @NotNull
    public Key<T> getKey() {
        Key<T> key = this.myKey;
        if (key == null) {
            DataNode.$$$reportNull$$$0(6);
        }
        return key;
    }

    @NotNull
    public T getData() {
        if (this.myData == null) {
            this.prepareData(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
        }
        T t = this.myData;
        if (t == null) {
            DataNode.$$$reportNull$$$0(7);
        }
        return t;
    }

    public boolean isIgnored() {
        return this.myIgnored;
    }

    public void setIgnored(boolean ignored) {
        this.myIgnored = ignored;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareData(final ClassLoader ... loaders) {
        if (loaders == null) {
            DataNode.$$$reportNull$$$0(8);
        }
        if (this.myData != null) {
            return;
        }
        ObjectInputStream oIn = null;
        try {
            oIn = new ObjectInputStream(new ByteArrayInputStream(this.myRawData)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    for (ClassLoader loader : loaders) {
                        try {
                            return Class.forName(name, false, loader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    return super.resolveClass(desc);
                }

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    for (ClassLoader loader : loaders) {
                        try {
                            return this.doResolveProxyClass(interfaces, loader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    return super.resolveProxyClass(interfaces);
                }

                private Class<?> doResolveProxyClass(@NotNull String[] interfaces, @NotNull ClassLoader loader) throws ClassNotFoundException {
                    if (interfaces == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (loader == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ClassLoader nonPublicLoader = null;
                    boolean hasNonPublicInterface = false;
                    Class[] classObjs = new Class[interfaces.length];
                    for (int i2 = 0; i2 < interfaces.length; ++i2) {
                        Class<?> cl = Class.forName(interfaces[i2], false, loader);
                        if ((cl.getModifiers() & 1) == 0) {
                            if (hasNonPublicInterface) {
                                if (nonPublicLoader != cl.getClassLoader()) {
                                    throw new IllegalAccessError("conflicting non-public interface class loaders");
                                }
                            } else {
                                nonPublicLoader = cl.getClassLoader();
                                hasNonPublicInterface = true;
                            }
                        }
                        classObjs[i2] = cl;
                    }
                    try {
                        return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClassNotFoundException(null, e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "interfaces";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "loader";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/model/DataNode$1";
                    objectArray[2] = "doResolveProxyClass";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myData = oIn.readObject();
            this.myRawData = null;
            assert (this.myData != null);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(oIn);
                throw throwable;
            }
        }
        StreamUtil.closeStream((Closeable)oIn);
    }

    @Nullable
    public <T> T getData(@NotNull Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(9);
        }
        if (this.myKey.equals(key)) {
            return this.myData;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p.myData;
            }
            p = p.myParent;
        }
        return null;
    }

    @Nullable
    public <T> DataNode<T> getDataNode(@NotNull Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(10);
        }
        if (this.myKey.equals(key)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    @Nullable
    public <P> DataNode<P> getParent(@NotNull Class<P> dataClass) {
        if (dataClass == null) {
            DataNode.$$$reportNull$$$0(11);
        }
        if (dataClass.isInstance(this.myData)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (dataClass.isInstance(p.myData)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    public void addChild(@NotNull DataNode<?> child) {
        if (child == null) {
            DataNode.$$$reportNull$$$0(12);
        }
        child.myParent = this;
        this.myChildren.add(child);
    }

    @NotNull
    public Collection<DataNode<?>> getChildren() {
        List<DataNode<?>> list = this.myChildrenView;
        if (list == null) {
            DataNode.$$$reportNull$$$0(13);
        }
        return list;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.myRawData = this.getDataBytes();
        }
        catch (IOException e) {
            LOG.warn("Unable to serialize the data node - " + this.toString());
            throw e;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.myChildrenView = Collections.unmodifiableList(this.myChildren);
        this.myUserData = new UserDataHolderBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() throws IOException {
        if (this.myRawData != null) {
            return this.myRawData;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (ObjectOutputStream oOut = new ObjectOutputStream(bOut);){
            oOut.writeObject(this.myData);
            byte[] bytes = bOut.toByteArray();
            this.myRawData = bytes;
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public int hashCode() {
        return 31 * this.myKey.hashCode() + this.getData().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!this.myChildren.equals(node.myChildren)) {
            return false;
        }
        if (!this.getData().equals(node.getData())) {
            return false;
        }
        return this.myKey.equals(node.myKey);
    }

    public String toString() {
        String dataDescription;
        try {
            dataDescription = this.getData().toString();
        }
        catch (Exception e) {
            dataDescription = "failed to load";
            LOG.debug((Throwable)e);
        }
        return String.format("%s: %s", this.myKey, dataDescription);
    }

    public void clear(boolean removeFromGraph) {
        if (removeFromGraph && this.myParent != null) {
            Iterator<DataNode<?>> iterator = this.myParent.myChildren.iterator();
            while (iterator.hasNext()) {
                DataNode<?> dataNode = iterator.next();
                if (System.identityHashCode(dataNode) != System.identityHashCode(this)) continue;
                iterator.remove();
                break;
            }
        }
        this.myParent = null;
        this.myRawData = null;
        this.myChildren.clear();
    }

    @NotNull
    public DataNode<T> graphCopy() {
        DataNode<T> dataNode = DataNode.copy(this, null);
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(14);
        }
        return dataNode;
    }

    @NotNull
    public DataNode<T> nodeCopy() {
        DataNode<T> dataNode = DataNode.nodeCopy(this);
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(15);
        }
        return dataNode;
    }

    @Nullable
    public <U> U getUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(16);
        }
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull com.intellij.openapi.util.Key<U> key, U value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(17);
        }
        this.myUserData.putUserData(key, value);
    }

    public <U> void removeUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(18);
        }
        this.myUserData.putUserData(key, null);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull com.intellij.openapi.util.Key<T> key, @NotNull T value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(19);
        }
        if (value == null) {
            DataNode.$$$reportNull$$$0(20);
        }
        Object object = this.myUserData.putUserDataIfAbsent(key, value);
        if (object == null) {
            DataNode.$$$reportNull$$$0(21);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull com.intellij.openapi.util.Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(22);
        }
        return this.myUserData.replace(key, oldValue, newValue);
    }

    public <T> void putCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key, T value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(23);
        }
        this.myUserData.putCopyableUserData(key, value);
    }

    public boolean isUserDataEmpty() {
        return this.myUserData.isUserDataEmpty();
    }

    public <T> T getCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(24);
        }
        return (T)this.myUserData.getCopyableUserData(key);
    }

    @NotNull
    public static <T> DataNode<T> nodeCopy(@NotNull DataNode<T> dataNode) {
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(25);
        }
        DataNode<T> copy = new DataNode<T>(dataNode.myKey);
        copy.myData = dataNode.myData;
        copy.myRawData = dataNode.myRawData;
        copy.myIgnored = dataNode.myIgnored;
        dataNode.myUserData.copyCopyableDataTo(copy.myUserData);
        DataNode<T> dataNode2 = copy;
        if (dataNode2 == null) {
            DataNode.$$$reportNull$$$0(26);
        }
        return dataNode2;
    }

    @NotNull
    private static <T> DataNode<T> copy(@NotNull DataNode<T> dataNode, @Nullable DataNode<?> newParent) {
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(27);
        }
        DataNode<T> copy = DataNode.nodeCopy(dataNode);
        copy.myParent = newParent;
        for (DataNode<?> child : dataNode.myChildren) {
            copy.addChild(DataNode.copy(child, copy));
        }
        DataNode<T> dataNode2 = copy;
        if (dataNode2 == null) {
            DataNode.$$$reportNull$$$0(28);
        }
        return dataNode2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/DataNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/DataNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "graphCopy";
                break;
            }
            case 15: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeCopy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 28: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeUserData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "nodeCopy";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

