/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BusyObject {
    @NotNull
    public ActionCallback getReady(@NotNull Object var1);

    public static abstract class Impl
    implements BusyObject {
        private final Map<Object, ActionCallback> myReadyCallbacks = new WeakHashMap<Object, ActionCallback>();

        public abstract boolean isReady();

        public final void onReady() {
            this.onReady(null);
        }

        public final void onReady(@Nullable Object readyRequestor) {
            if (!this.isReady()) {
                return;
            }
            if (readyRequestor != null) {
                Pair<ActionCallback, List<ActionCallback>> callbacks = this.getReadyCallbacks(readyRequestor);
                ((ActionCallback)callbacks.getFirst()).setDone();
                for (ActionCallback each : (List)callbacks.getSecond()) {
                    each.setRejected();
                }
            } else {
                ActionCallback[] callbacks;
                for (ActionCallback each : callbacks = this.getReadyCallbacks()) {
                    each.setDone();
                }
            }
            this.onReadyWasSent();
        }

        protected void onReadyWasSent() {
        }

        @Override
        @NotNull
        public final ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                Impl.$$$reportNull$$$0(0);
            }
            if (this.isReady()) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    Impl.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }
            ActionCallback actionCallback = this.addReadyCallback(requestor);
            if (actionCallback == null) {
                Impl.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ActionCallback addReadyCallback(Object requestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback cb = this.myReadyCallbacks.get(requestor);
            if (cb == null) {
                cb = new ActionCallback();
                this.myReadyCallbacks.put(requestor, cb);
            }
            ActionCallback actionCallback = cb;
            // MONITOREXIT : map
            if (actionCallback != null) return actionCallback;
            Impl.$$$reportNull$$$0(3);
            return actionCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ActionCallback[] getReadyCallbacks() {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback[] result = this.myReadyCallbacks.values().toArray(new ActionCallback[this.myReadyCallbacks.size()]);
            this.myReadyCallbacks.clear();
            // MONITOREXIT : map
            if (result != null) return result;
            Impl.$$$reportNull$$$0(4);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private Pair<ActionCallback, List<ActionCallback>> getReadyCallbacks(Object readyRequestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback done2 = this.myReadyCallbacks.get(readyRequestor);
            if (done2 == null) {
                done2 = new ActionCallback();
            }
            this.myReadyCallbacks.remove(readyRequestor);
            ArrayList<ActionCallback> rejected2 = new ArrayList<ActionCallback>();
            rejected2.addAll(this.myReadyCallbacks.values());
            this.myReadyCallbacks.clear();
            Pair pair = new Pair((Object)done2, rejected2);
            // MONITOREXIT : map
            if (pair != null) return pair;
            Impl.$$$reportNull$$$0(5);
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/BusyObject$Impl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/BusyObject$Impl";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReady";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addReadyCallback";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadyCallbacks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReady";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class Simple
        extends Impl {
            private final AtomicInteger myBusyCount = new AtomicInteger();

            @Override
            public boolean isReady() {
                return this.myBusyCount.get() == 0;
            }

            @NotNull
            public ActionCallback execute(@NotNull ActiveRunnable runnable) {
                if (runnable == null) {
                    Simple.$$$reportNull$$$0(0);
                }
                this.myBusyCount.addAndGet(1);
                ActionCallback cb = runnable.run();
                cb.doWhenProcessed(() -> {
                    this.myBusyCount.addAndGet(-1);
                    if (this.isReady()) {
                        this.onReady();
                    }
                });
                ActionCallback actionCallback = cb;
                if (actionCallback == null) {
                    Simple.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/util/BusyObject$Impl$Simple";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/util/BusyObject$Impl$Simple";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

