/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.ByteArrayCharSequence;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){

        @Override
        public int hash(EntryInfo info) {
            return System.identityHashCode(info);
        }

        @Override
        public EntryInfo key(Object o) {
            if (o instanceof EntryInfo) {
                return ((EntryInfo)o).parent;
            }
            return ((EntryInfo[])o)[0].parent;
        }
    };

    protected ArchiveHandler(@NotNull String path2) {
        if (path2 == null) {
            ArchiveHandler.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference(null);
        this.myChildrenEntries = new SoftReference(null);
        this.myPath = new File(path2);
    }

    @NotNull
    public File getFile() {
        File file = this.myPath;
        if (file == null) {
            ArchiveHandler.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(2);
        }
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((File)this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    @NotNull
    public String[] list(@NotNull String relativePath) {
        EntryInfo entry;
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(3);
        }
        if ((entry = this.getEntryInfo(relativePath)) == null || !entry.isDirectory) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                ArchiveHandler.$$$reportNull$$$0(4);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        AddonlyKeylessHash<EntryInfo, Object> result = this.getParentChildrenMap();
        Object o = result.get(entry);
        if (o == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                ArchiveHandler.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (o instanceof EntryInfo) {
            String[] stringArray = new String[]{((EntryInfo)o).shortName.toString()};
            if (stringArray == null) {
                ArchiveHandler.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        EntryInfo[] infos = (EntryInfo[])o;
        String[] names = new String[infos.length];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            names[i2] = infos[i2].shortName.toString();
        }
        if (names == null) {
            ArchiveHandler.$$$reportNull$$$0(7);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AddonlyKeylessHash<EntryInfo, Object> getParentChildrenMap() {
        AddonlyKeylessHash<EntryInfo, Object> map = (AddonlyKeylessHash<EntryInfo, Object>)SoftReference.dereference(this.myChildrenEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (AddonlyKeylessHash)SoftReference.dereference(this.myChildrenEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                    } else {
                        try {
                            map = this.createParentChildrenMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                        }
                    }
                    this.myChildrenEntries = new SoftReference(map);
                }
            }
        }
        AddonlyKeylessHash<EntryInfo, Object> addonlyKeylessHash = map;
        if (addonlyKeylessHash == null) {
            ArchiveHandler.$$$reportNull$$$0(8);
        }
        return addonlyKeylessHash;
    }

    private AddonlyKeylessHash<EntryInfo, Object> createParentChildrenMap() {
        THashMap map = new THashMap();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.isDirectory && !map.containsKey((Object)info)) {
                map.put((Object)info, (Object)new SmartList());
            }
            if (info.parent == null) continue;
            List parentChildren = (List)map.get((Object)info.parent);
            if (parentChildren == null) {
                parentChildren = new SmartList();
                map.put((Object)info.parent, (Object)parentChildren);
            }
            parentChildren.add(info);
        }
        final AddonlyKeylessHash<EntryInfo, Object> result = new AddonlyKeylessHash<EntryInfo, Object>(map.size(), ourKeyValueMapper);
        map.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<EntryInfo, List<EntryInfo>>(){

            public boolean execute(EntryInfo a, List<EntryInfo> b) {
                int numberOfChildren = b.size();
                if (numberOfChildren == 1) {
                    result.add(b.get(0));
                } else if (numberOfChildren > 1) {
                    result.add(b.toArray(new EntryInfo[numberOfChildren]));
                }
                return true;
            }
        });
        return result;
    }

    public void dispose() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(9);
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<Object, Object> map = (Map)SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (Map)SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference(map);
                }
            }
        }
        Map map2 = map;
        if (map2 == null) {
            ArchiveHandler.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        EntryInfo entryInfo = new EntryInfo("", true, 0L, -1L, null);
        if (entryInfo == null) {
            ArchiveHandler.$$$reportNull$$$0(11);
        }
        return entryInfo;
    }

    @NotNull
    protected EntryInfo getOrCreate(@NotNull Map<String, EntryInfo> map, @NotNull String entryName) {
        EntryInfo entry;
        if (map == null) {
            ArchiveHandler.$$$reportNull$$$0(12);
        }
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(13);
        }
        if ((entry = map.get(entryName)) == null) {
            Pair<String, String> path2 = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path2.first);
            CharSequence shortName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)((String)path2.second));
            entry = new EntryInfo(shortName, true, 0L, -1L, parentEntry);
            map.put(entryName, entry);
        }
        EntryInfo entryInfo = entry;
        if (entryInfo == null) {
            ArchiveHandler.$$$reportNull$$$0(14);
        }
        return entryInfo;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        int p;
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(15);
        }
        String parentName = (p = entryName.lastIndexOf(47)) > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        Pair pair = Pair.create((Object)parentName, (Object)shortName);
        if (pair == null) {
            ArchiveHandler.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull String var1) throws IOException;

    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(17);
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(relativePath));
        if (bufferExposingByteArrayInputStream == null) {
            ArchiveHandler.$$$reportNull$$$0(18);
        }
        return bufferExposingByteArrayInputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentChildrenMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootEntry";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEntryInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent;
            if (shortName == null) {
                EntryInfo.$$$reportNull$$$0(0);
            }
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
        }
    }
}

