/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, @NotNull VirtualFile file, @VirtualFile.PropName @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue, boolean isFromRefresh) {
        if (file == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(1);
        }
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        VFilePropertyChangeEvent.checkPropertyValuesCorrect(requestor, propertyName, oldValue, newValue);
    }

    public static void checkPropertyValuesCorrect(Object requestor, @VirtualFile.PropName @NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(2);
        }
        if (Comparing.equal((Object)oldValue, (Object)newValue) && "FileContentUtilCore.saveOrReload" != requestor) {
            throw new IllegalArgumentException("Values must be different, got the same: " + oldValue);
        }
        switch (propertyName) {
            case "name": {
                if (oldValue == null) {
                    throw new IllegalArgumentException("oldName must not be null");
                }
                if (newValue != null) break;
                throw new IllegalArgumentException("newName must not be null");
            }
            case "encoding": {
                if (oldValue != null) break;
                throw new IllegalArgumentException("oldCharset must not be null");
            }
            case "writable": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldWriteable must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newWriteable must be boolean, got " + newValue);
            }
            case "HIDDEN": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldHidden must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newHidden must be boolean, got " + newValue);
            }
            case "symlink": {
                if (oldValue != null && !(oldValue instanceof String)) {
                    throw new IllegalArgumentException("oldSymTarget must be String, got " + oldValue);
                }
                if (newValue == null || newValue instanceof String) break;
                throw new IllegalArgumentException("newSymTarget must be String, got " + newValue);
            }
            default: {
                throw new IllegalArgumentException("Unknown property name: '" + propertyName + "'. Must be one of: VirtualFile.PROP_NAME, VirtualFile.PROP_ENCODING, VirtualFile.PROP_WRITABLE, VirtualFile.PROP_HIDDEN, VirtualFile.PROP_SYMLINK_TARGET");
            }
        }
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    @NotNull
    @VirtualFile.PropName
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.computePath();
        if (string == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected String computePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(7);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (this.myNewValue != null ? !this.myNewValue.equals(event.myNewValue) : event.myNewValue != null) {
            return false;
        }
        if (this.myOldValue != null ? !this.myOldValue.equals(event.myOldValue) : event.myOldValue != null) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myPropertyName.hashCode();
        result = 31 * result + (this.myOldValue != null ? this.myOldValue.hashCode() : 0);
        result = 31 * result + (this.myNewValue != null ? this.myNewValue.hashCode() : 0);
        return result;
    }

    @NotNull
    @NonNls
    public String toString() {
        String string = "VfsEvent[property(" + this.myPropertyName + ") changed for '" + this.myFile + "': oldValue = " + this.myOldValue + ", newValue = " + this.myNewValue + "]";
        if (string == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getOldPath() {
        String newName;
        int i2;
        String path2 = this.getPath();
        if ("name".equals(this.myPropertyName) && this.myNewValue instanceof String && this.myOldValue instanceof String && (i2 = path2.lastIndexOf(newName = (String)this.myNewValue)) != -1) {
            path2 = new StringBuilder(path2).replace(i2, i2 + newName.length(), (String)this.myOldValue).toString();
        }
        String string = path2;
        if (string == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyValuesCorrect";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

