/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPattern
extends ObjectPattern<String, StringPattern> {
    static final StringPattern STRING_PATTERN = new StringPattern();

    private StringPattern() {
        super(new InitialPatternCondition<String>(String.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof String;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder.append("string()");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StringPattern$1", "append"));
            }
        });
    }

    @NotNull
    public StringPattern startsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(0);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("startsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.startsWith((CharSequence)str, (CharSequence)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$2", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(1);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(2);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("endsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    3.$$$reportNull$$$0(0);
                }
                return StringUtil.endsWith((CharSequence)str, (CharSequence)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$3", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(3);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(4);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    4.$$$reportNull$$$0(0);
                }
                return StringUtil.contains((CharSequence)str, (CharSequence)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$4", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(5);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern containsChars(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(6);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("containsChars"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    5.$$$reportNull$$$0(0);
                }
                return StringUtil.containsAnyChar((String)str, (String)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$5", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(7);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matches(final @NonNls @NotNull String s) {
        String escaped;
        if (s == null) {
            StringPattern.$$$reportNull$$$0(8);
        }
        if ((escaped = StringUtil.escapeToRegexp((String)s)).equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                StringPattern.$$$reportNull$$$0(9);
            }
            return stringPattern;
        }
        final Pattern pattern = Pattern.compile(s);
        StringPattern stringPattern = (StringPattern)this.with(new ValuePatternCondition<String>("matches"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    6.$$$reportNull$$$0(0);
                }
                return pattern.matcher(StringPattern.newBombedCharSequence(str)).matches();
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$6", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(10);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matchesBrics(final @NonNls @NotNull String s) {
        String escaped;
        if (s == null) {
            StringPattern.$$$reportNull$$$0(11);
        }
        if ((escaped = StringUtil.escapeToRegexp((String)s)).equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                StringPattern.$$$reportNull$$$0(12);
            }
            return stringPattern;
        }
        StringBuilder sb = new StringBuilder(s.length() * 5);
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (c == ' ') {
                sb.append("<whitespacechar>");
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                continue;
            }
            sb.append(c);
        }
        RegExp regExp = new RegExp(sb.toString());
        Automaton automaton = regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider());
        final RunAutomaton runAutomaton = new RunAutomaton(automaton, true);
        StringPattern stringPattern = (StringPattern)this.with(new ValuePatternCondition<String>("matchesBrics"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    7.$$$reportNull$$$0(0);
                }
                return runAutomaton.run(str);
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$7", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(13);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull ElementPattern<Character> pattern) {
        if (pattern == null) {
            StringPattern.$$$reportNull$$$0(14);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    8.$$$reportNull$$$0(0);
                }
                for (int i2 = 0; i2 < str.length(); ++i2) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i2)))) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$8", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(15);
        }
        return stringPattern;
    }

    public StringPattern longerThan(final int minLength) {
        return (StringPattern)this.with(new PatternCondition<String>("longerThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    9.$$$reportNull$$$0(0);
                }
                return s.length() > minLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$9", "accepts"));
            }
        });
    }

    public StringPattern shorterThan(final int maxLength) {
        return (StringPattern)this.with(new PatternCondition<String>("shorterThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    10.$$$reportNull$$$0(0);
                }
                return s.length() < maxLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$10", "accepts"));
            }
        });
    }

    public StringPattern withLength(final int length) {
        return (StringPattern)this.with(new PatternCondition<String>("withLength"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    11.$$$reportNull$$$0(0);
                }
                return s.length() == length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$11", "accepts"));
            }
        });
    }

    @NotNull
    public StringPattern oneOf(String ... values) {
        StringPattern stringPattern = (StringPattern)super.oneOf(values);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(16);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOfIgnoreCase(String ... values) {
        StringPattern stringPattern = (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(17);
        }
        return stringPattern;
    }

    @Override
    @NotNull
    public StringPattern oneOf(@NonNls Collection<String> set) {
        StringPattern stringPattern = (StringPattern)super.oneOf(set);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(18);
        }
        return stringPattern;
    }

    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringPattern.$$$reportNull$$$0(19);
        }
        if (sequence instanceof StringUtil.BombedCharSequence) {
            CharSequence charSequence = sequence;
            if (charSequence == null) {
                StringPattern.$$$reportNull$$$0(20);
            }
            return charSequence;
        }
        StringUtil.BombedCharSequence bombedCharSequence = new StringUtil.BombedCharSequence(sequence){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        if (bombedCharSequence == null) {
            StringPattern.$$$reportNull$$$0(21);
        }
        return bombedCharSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "endsWith";
                break;
            }
            case 5: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "containsChars";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "matchesBrics";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOfIgnoreCase";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 4: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsChars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchesBrics";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

