/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPrimitiveType
extends PsiType.Stub
implements JvmPrimitiveType {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap();
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new THashMap();
    private final String myName;

    PsiPrimitiveType(@NotNull String name, String boxedName) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(0);
        }
        this(name, TypeAnnotationProvider.EMPTY);
        if (boxedName != null) {
            ourQNameToUnboxed.put(boxedName, this);
            ourUnboxedToQName.put(this, boxedName);
        }
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull PsiAnnotation[] annotations) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(1);
        }
        if (annotations == null) {
            PsiPrimitiveType.$$$reportNull$$$0(2);
        }
        super(annotations);
        this.myName = name;
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(4);
        }
        super(provider);
        this.myName = name;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(5);
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            PsiPrimitiveType.$$$reportNull$$$0(6);
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(9);
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiPrimitiveType.$$$reportNull$$$0(10);
        }
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiPrimitiveType.$$$reportNull$$$0(11);
        }
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            PsiPrimitiveType.$$$reportNull$$$0(12);
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type);
        LanguageLevel languageLevel = ((PsiClassType)type).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type.getAnnotationProvider());
    }

    @Nullable
    public static PsiPrimitiveType getOptionallyUnboxedType(PsiType type) {
        return type instanceof PsiPrimitiveType ? (PsiPrimitiveType)type : PsiPrimitiveType.getUnboxedType(type);
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            PsiPrimitiveType.$$$reportNull$$$0(13);
        }
        if ((file = context.getContainingFile()) == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file.getProject());
        PsiClass aClass = facade.findClass(boxedQName, file.getResolveScope());
        if (aClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        String boxedQName;
        if (manager == null) {
            PsiPrimitiveType.$$$reportNull$$$0(14);
        }
        if (resolveScope == null) {
            PsiPrimitiveType.$$$reportNull$$$0(15);
        }
        if ((boxedQName = this.getBoxedTypeName()) == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass);
    }

    public static Collection<String> getAllBoxedTypeNames() {
        return Collections.unmodifiableCollection(ourQNameToUnboxed.keySet());
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiPrimitiveType && this.myName.equals(((PsiPrimitiveType)obj).myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

