/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private List<NamedScope> myScopes;
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners;

    public NamedScopesHolder(@NotNull Project project) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(0);
        }
        this.myScopes = new ArrayList<NamedScope>();
        this.myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    public void addScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            NamedScopesHolder.$$$reportNull$$$0(1);
        }
        this.myScopeListeners.add(scopeListener);
    }

    public void removeScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            NamedScopesHolder.$$$reportNull$$$0(2);
        }
        this.myScopeListeners.remove(scopeListener);
    }

    public void fireScopeListeners() {
        for (ScopeListener listener : this.myScopeListeners) {
            listener.scopesChanged();
        }
    }

    @NotNull
    public NamedScope[] getScopes() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        List<NamedScope> list = this.getPredefinedScopes();
        scopes.addAll(list);
        scopes.addAll(this.myScopes);
        NamedScope[] namedScopeArray = scopes.toArray(new NamedScope[scopes.size()]);
        if (namedScopeArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(3);
        }
        return namedScopeArray;
    }

    @NotNull
    public NamedScope[] getEditableScopes() {
        NamedScope[] namedScopeArray = this.myScopes.toArray(new NamedScope[this.myScopes.size()]);
        if (namedScopeArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(4);
        }
        return namedScopeArray;
    }

    public void removeAllSets() {
        this.myScopes.clear();
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope[] scopes) {
        this.myScopes = new ArrayList<NamedScope>(Arrays.asList(scopes));
        this.fireScopeListeners();
    }

    public void addScope(NamedScope scope) {
        this.myScopes.add(scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(@NotNull Project project, String scopeName) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(5);
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    @NotNull
    public static NamedScopesHolder[] getAllNamedScopeHolders(@NotNull Project project) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(6);
        }
        NamedScopesHolder[] holders = new NamedScopesHolder[]{NamedScopeManager.getInstance(project), DependencyValidationManager.getInstance(project)};
        if (holders == null) {
            NamedScopesHolder.$$$reportNull$$$0(7);
        }
        return holders;
    }

    @Nullable
    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    private static Element writeScope(NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    private static NamedScope readScope(Element setElement) {
        PackageSet set;
        String name = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set = new InvalidPackageSet(attributeValue);
        }
        return new NamedScope(name, set);
    }

    @Override
    public void loadState(Element state) {
        this.myScopes.clear();
        List sets = state.getChildren(SCOPE_TAG);
        for (Element set : sets) {
            this.myScopes.add(NamedScopesHolder.readScope(set));
        }
        this.fireScopeListeners();
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
        return element;
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return this.getPredefinedScope(name);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list = Collections.emptyList();
        if (list == null) {
            NamedScopesHolder.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public NamedScope getPredefinedScope(@NotNull String name) {
        if (name == null) {
            NamedScopesHolder.$$$reportNull$$$0(9);
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(10);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeListener";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATT;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableScopes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNamedScopeHolders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addScopeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeScopeListener";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllNamedScopeHolders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ScopeListener {
        public void scopesChanged();
    }
}

