/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(1);
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(2);
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(3);
        }
        if (!parameters.isCheckDeep()) {
            Query<PsiClass> directQuery = DirectClassInheritorsSearch.search(parameters.getClassToProcess(), parameters.getScope(), parameters.isIncludeAnonymous());
            if (parameters.getNameCondition() != Conditions.alwaysTrue()) {
                directQuery = new FilteredQuery<PsiClass>(directQuery, psiClass -> {
                    if (parameters == null) {
                        ClassInheritorsSearch.$$$reportNull$$$0(17);
                    }
                    return parameters.getNameCondition().value(ReadAction.compute(psiClass::getName));
                });
            }
            Query<PsiClass> query = AbstractQuery.wrapInReadAction(directQuery);
            if (query == null) {
                ClassInheritorsSearch.$$$reportNull$$$0(4);
            }
            return query;
        }
        Query<PsiClass> query = INSTANCE.createUniqueResultsQuery(parameters, ContainerUtil.canonicalStrategy(), psiClass -> (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.getInstance(psiClass.getProject()).createSmartPsiElementPointer(psiClass)));
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(5);
        }
        return query;
    }

    @Deprecated
    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(7);
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(8);
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(10);
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, scope, checkDeep, true, true);
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(11);
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(12);
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, (SearchScope)ReadAction.compute(() -> {
            if (aClass == null) {
                ClassInheritorsSearch.$$$reportNull$$$0(16);
            }
            if (!aClass.isValid()) {
                throw new ProcessCanceledException();
            }
            PsiFile file = aClass.getContainingFile();
            return (file != null ? file : aClass).getUseScope();
        }), checkDeep);
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(13);
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(14);
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, true);
        if (query == null) {
            ClassInheritorsSearch.$$$reportNull$$$0(15);
        }
        return query;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/ClassInheritorsSearch";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/ClassInheritorsSearch";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$search$3";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$search$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        @NotNull
        private final Condition<String> myNameCondition;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<String>)Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            if (aClass == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            if (nameCondition == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            assert (checkInheritance);
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            return psiClass;
        }

        @NotNull
        public Condition<String> getNameCondition() {
            Condition<String> condition = this.myNameCondition;
            if (condition == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            return condition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            return searchScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }

        public String toString() {
            return "'" + this.myClass.getQualifiedName() + "' scope=" + this.myScope + (this.myCheckDeep ? " (deep)" : "") + (this.myCheckInheritance ? " (check inheritance)" : "") + (this.myIncludeAnonymous ? " (anonymous)" : "") + (this.myNameCondition == Conditions.alwaysTrue() ? "" : " condition: " + this.myNameCondition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            if (this.myCheckDeep != that.myCheckDeep) {
                return false;
            }
            if (this.myCheckInheritance != that.myCheckInheritance) {
                return false;
            }
            if (this.myIncludeAnonymous != that.myIncludeAnonymous) {
                return false;
            }
            if (!this.myClass.equals(that.myClass)) {
                return false;
            }
            if (!this.myScope.equals(that.myScope)) {
                return false;
            }
            return this.myNameCondition.equals(that.myNameCondition);
        }

        public int hashCode() {
            int result = this.myClass.hashCode();
            result = 31 * result + this.myScope.hashCode();
            result = 31 * result + (this.myCheckDeep ? 1 : 0);
            result = 31 * result + (this.myCheckInheritance ? 1 : 0);
            result = 31 * result + (this.myIncludeAnonymous ? 1 : 0);
            result = 31 * result + this.myNameCondition.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameCondition";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassToProcess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCondition";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

