/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i2 = className.lastIndexOf(46);
            return i2 == -1 ? "" : className.substring(0, i2);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName) {
        int i2;
        if (fqName == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        String string = (i2 = fqName.lastIndexOf(46)) == -1 ? fqName : fqName.substring(i2 + 1);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        String qName;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            ClassUtil.$$$reportNull$$$0(3);
        }
        if ((qName = aClass.getQualifiedName()) != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass, parentClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(5);
        }
        TObjectIntHashMap indices = (TObjectIntHashMap)CachedValuesManager.getCachedValue(containingClass, () -> {
            if (containingClass == null) {
                ClassUtil.$$$reportNull$$$0(25);
            }
            TObjectIntHashMap map = new TObjectIntHashMap();
            int index = 0;
            for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass.getQualifiedName() != null) continue;
                map.put((Object)aClass, ++index);
            }
            return CachedValueProvider.Result.create(map, containingClass);
        });
        return indices.get((Object)psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, @NotNull PsiClass containingClass) {
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(7);
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        String prefix;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        final int idx = !(prefix = ClassUtil.getDigitPrefix(indexName)).isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual((String)name, (String)aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual((String)name, (String)aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i2;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        for (i2 = 0; i2 < indexName.length() && Character.isDigit(c = indexName.charAt(i2)); ++i2) {
        }
        String string = i2 == 0 ? "" : indexName.substring(0, i2);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(15);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            ClassUtil.$$$reportNull$$$0(18);
        }
        if (parent != null) {
            return ClassUtil.findSubClass(name, parent, jvmCompatible);
        }
        PsiClass result = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent, boolean jvmCompatible) {
        PsiClass result;
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            ClassUtil.$$$reportNull$$$0(20);
        }
        PsiClass psiClass = result = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent, jvmCompatible) : parent.findInnerClassByName(name, false);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent, jvmCompatible) : parent.findInnerClassByName(prefix, false);
            if (subClass == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(21);
        }
        if ((containingClass = aClass.getContainingClass()) != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(22);
        }
        if (jvmClassName == null) {
            ClassUtil.$$$reportNull$$$0(23);
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(24);
        }
        if (aClass.getContainingClass() != null) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 2: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigitPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatClassName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNonQualifiedClassIdx";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findNonQualifiedClassByIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDigitPrefix";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSubClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJVMClassName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClassByJVMName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNonQualifiedClassIdx$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

