/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiConcatenationUtil {
    public static void buildFormatString(PsiExpression expression, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
            String text = String.valueOf(literalExpression.getValue());
            String formatText = printfFormat ? StringUtil.escapeStringCharacters((String)text).replace("%", "%%").replace("\\'", "'") : StringUtil.escapeStringCharacters((String)text).replace("'", "''").replaceAll("((\\{|})+)", "'$1'");
            formatString.append(formatText);
        } else if (expression instanceof PsiPolyadicExpression) {
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType left = operands[0].getType();
                boolean bl = stringStarted = left != null && left.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat);
                }
                for (int i2 = 1; i2 < operands.length; ++i2) {
                    PsiExpression op = operands[i2];
                    PsiType optype = op.getType();
                    PsiType r = TypeConversionUtil.calcTypeForBinaryExpression(left, optype, binaryExpression.getOperationTokenType(), true);
                    if (r != null && r.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getElementFactory(binaryExpression.getProject()).createExpressionFromText(text, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || PsiType.CHAR.equals(optype))) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    left = r;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
        }
    }

    private static void addFormatParameter(@NotNull PsiExpression expression, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        if (expression == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(0);
        }
        PsiType type = expression.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type != null && (type.equalsToText("long") || type.equalsToText("int") || type.equalsToText("java.lang.Long") || type.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression));
    }

    private static PsiExpression getBoxedArgument(@NotNull PsiExpression arg) {
        if (arg == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isLanguageLevel5OrHigher(arg = (PsiExpression)ObjectUtils.coalesce((Object)PsiConcatenationUtil.unwrapExpression(arg), (Object)arg))) {
            return arg;
        }
        PsiType type = arg.getType();
        if (!(type instanceof PsiPrimitiveType) || type.equals(PsiType.NULL)) {
            return arg;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg;
        }
        GlobalSearchScope resolveScope = arg.getResolveScope();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(arg.getProject());
        PsiJavaCodeReferenceElement ref = factory.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList = newExpr.getArgumentList();
        assert (argumentList != null);
        argumentList.getExpressions()[0].replace(arg);
        return newExpr;
    }

    @Nullable
    private static PsiExpression unwrapExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(2);
        }
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiType castType = typeCastExpression.getType();
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return expression;
            }
            if (TypeConversionUtil.isNumericType(castType)) {
                int operandRank;
                PsiType operandType = operand.getType();
                if (operandType == null) {
                    return expression;
                }
                int castRank = TypeConversionUtil.getTypeRank(castType);
                if (castRank < (operandRank = TypeConversionUtil.getTypeRank(operandType)) || castRank == 3 && operandRank != castRank) {
                    return expression;
                }
            }
            expression = operand;
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiConcatenationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFormatParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBoxedArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unwrapExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

