/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationPanel
extends JPanel
implements IntentionActionProvider,
Weighted {
    protected final JLabel myLabel = new JLabel();
    protected final JLabel myGearLabel = new JLabel();
    protected final JPanel myLinksPanel = new NonOpaquePanel(new HorizontalLayout(JBUI.scale((int)5)));
    protected Color myBackgroundColor;
    protected ColorKey myBackgroundColorKey;

    public EditorNotificationPanel(@Nullable Color backgroundColor) {
        this();
        this.myBackgroundColor = backgroundColor;
    }

    public EditorNotificationPanel(@Nullable ColorKey backgroundColorKey) {
        this();
        this.myBackgroundColorKey = backgroundColorKey;
    }

    public EditorNotificationPanel() {
        super(new BorderLayout());
        NonOpaquePanel panel = new NonOpaquePanel(new BorderLayout());
        panel.add("Center", this.myLabel);
        panel.add("East", this.myLinksPanel);
        panel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
        panel.setMinimumSize(new Dimension(0, 0));
        this.add("Center", panel);
        this.add("East", this.myGearLabel);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }

    public EditorNotificationPanel text(@NotNull String text) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(0);
        }
        this.myLabel.setText(text);
        return this;
    }

    public EditorNotificationPanel icon(@NotNull Icon icon) {
        if (icon == null) {
            EditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this.myLabel.setIcon(icon);
        return this;
    }

    @Override
    public Color getBackground() {
        Color color;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        if (this.myBackgroundColorKey != null && (color = globalScheme.getColor(this.myBackgroundColorKey)) != null) {
            return color;
        }
        color = globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color != null ? color : UIUtil.getToolTipBackground();
    }

    public HyperlinkLabel createActionLabel(String text, @NonNls String actionId) {
        return this.createActionLabel(text, () -> this.executeAction(actionId));
    }

    public HyperlinkLabel createActionLabel(String text, final Runnable action) {
        HyperlinkLabel label = new HyperlinkLabel(text, this.getBackground());
        label.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        this.myLinksPanel.add(label);
        return label;
    }

    protected void executeAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, "unknown", DataManager.getInstance().getDataContext(this));
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            action.actionPerformed(event);
        }
    }

    @Override
    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        MyIntentionAction action = new MyIntentionAction();
        return action.getOptions().isEmpty() ? null : action;
    }

    @Override
    public double getWeight() {
        return 0.0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/EditorNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "icon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MySettingsOption
    implements IntentionAction,
    Iconable,
    LowPriorityAction {
        private final JLabel myLabel;

        private MySettingsOption(JLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = EditorBundle.message("editor.notification.settings.option.name", new Object[0]);
            if (string == null) {
                MySettingsOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification settings" == null) {
                MySettingsOption.$$$reportNull$$$0(1);
            }
            return "Editor notification settings";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(3);
            }
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 501, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myLabel.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyLinkOption
    implements IntentionAction {
        private final HyperlinkLabel myLabel;

        private MyLinkOption(HyperlinkLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = this.myLabel.getText();
            if (string == null) {
                MyLinkOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification option" == null) {
                MyLinkOption.$$$reportNull$$$0(1);
            }
            return "Editor notification option";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(3);
            }
            this.myLabel.doClick();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyIntentionAction
    extends AbstractEmptyIntentionAction
    implements IntentionActionWithOptions,
    Iconable {
        private final List<IntentionAction> myOptions = new ArrayList<IntentionAction>();

        private MyIntentionAction() {
            for (Component component : EditorNotificationPanel.this.myLinksPanel.getComponents()) {
                if (!(component instanceof HyperlinkLabel)) continue;
                this.myOptions.add(new MyLinkOption((HyperlinkLabel)component));
            }
            if (EditorNotificationPanel.this.myGearLabel.getIcon() != null) {
                this.myOptions.add(new MySettingsOption(EditorNotificationPanel.this.myGearLabel));
            }
        }

        @Override
        @NotNull
        public List<IntentionAction> getOptions() {
            List<IntentionAction> list = this.myOptions;
            if (list == null) {
                MyIntentionAction.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String text = EditorNotificationPanel.this.myLabel.getText();
            String string = StringUtil.isEmpty((String)text) ? EditorBundle.message("editor.notification.default.action.name", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)text, (int)50, (int)0);
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Editor notification" == null) {
                MyIntentionAction.$$$reportNull$$$0(2);
            }
            return "Editor notification";
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AllIcons.Actions.IntentionBulb;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

