/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandedItemRendererComponentWrapper
extends JComponent {
    JComponent owner;

    public ExpandedItemRendererComponentWrapper(final @NotNull Component rendererComponent) {
        if (rendererComponent == null) {
            ExpandedItemRendererComponentWrapper.$$$reportNull$$$0(0);
        }
        this.add(rendererComponent);
        this.setOpaque(false);
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return rendererComponent.getPreferredSize();
            }

            public void layoutContainer(Container parent) {
                Dimension size = parent.getSize();
                if (ExpandedItemRendererComponentWrapper.this.owner != null) {
                    Rectangle visible = ExpandedItemRendererComponentWrapper.this.owner.getVisibleRect();
                    size.width = visible.x + visible.width;
                }
                Insets i2 = parent.getInsets();
                Dimension pref = rendererComponent.getPreferredSize();
                rendererComponent.setBounds(i2.left, i2.top, Math.max(pref.width, size.width - i2.left - i2.right), size.height - i2.top - i2.bottom);
            }
        });
    }

    private ExpandedItemRendererComponentWrapper() {
    }

    public static ExpandedItemRendererComponentWrapper wrap(@NotNull Component rendererComponent) {
        if (rendererComponent == null) {
            ExpandedItemRendererComponentWrapper.$$$reportNull$$$0(1);
        }
        if (rendererComponent instanceof Accessible) {
            return new MyAccessibleComponent(rendererComponent, (Accessible)((Object)rendererComponent));
        }
        return new ExpandedItemRendererComponentWrapper(rendererComponent);
    }

    @Override
    public void setBorder(Border border) {
        JComponent rendererComponent = this.getRendererComponent();
        if (rendererComponent != null) {
            rendererComponent.setBorder(border);
            return;
        }
        super.setBorder(border);
    }

    @Override
    public String getToolTipText() {
        JComponent rendererComponent = this.getRendererComponent();
        if (rendererComponent != null) {
            return rendererComponent.getToolTipText();
        }
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        JComponent rendererComponent = this.getRendererComponent();
        if (rendererComponent != null) {
            return rendererComponent.getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        JComponent rendererComponent = this.getRendererComponent();
        if (rendererComponent != null) {
            return rendererComponent.getToolTipLocation(event);
        }
        return super.getToolTipLocation(event);
    }

    @Nullable
    private JComponent getRendererComponent() {
        Component component;
        if (this.getComponentCount() == 1 && (component = this.getComponent(0)) instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "rendererComponent";
        objectArray2[1] = "com/intellij/ui/ExpandedItemRendererComponentWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAccessibleComponent
    extends ExpandedItemRendererComponentWrapper
    implements Accessible {
        private Accessible myAccessible;

        MyAccessibleComponent(@NotNull Component comp, @NotNull Accessible accessible) {
            if (comp == null) {
                MyAccessibleComponent.$$$reportNull$$$0(0);
            }
            if (accessible == null) {
                MyAccessibleComponent.$$$reportNull$$$0(1);
            }
            super(comp);
            this.myAccessible = accessible;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            this.accessibleContext = this.myAccessible.getAccessibleContext();
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessible";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/ExpandedItemRendererComponentWrapper$MyAccessibleComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

