/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.Nullable;

public class SearchTextField
extends JPanel {
    public static final DataKey<SearchTextField> KEY = DataKey.create("search.text.field");
    public static final KeyStroke SHOW_HISTORY_KEYSTROKE = KeyStroke.getKeyStroke(40, 512);
    public static final CustomShortcutSet SHOW_HISTORY_SHORTCUT = new CustomShortcutSet(SHOW_HISTORY_KEYSTROKE);
    public static final KeyStroke ALT_SHOW_HISTORY_KEYSTROKE = KeyStroke.getKeyStroke(38, 512);
    public static final CustomShortcutSet ALT_SHOW_HISTORY_SHORTCUT = new CustomShortcutSet(ALT_SHOW_HISTORY_KEYSTROKE);
    private int myHistorySize = 5;
    private int myCurrentHistoryIndex = 0;
    private final MyModel myModel = new MyModel();
    private final TextFieldWithProcessing myTextField = new TextFieldWithProcessing(){

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (SearchTextField.this.preprocessEventForTextField(e)) {
                return;
            }
            super.processKeyEvent(e);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            TextUI ui = this.getUI();
            if (ui instanceof Condition && ((Condition)ui).value((Object)e)) {
                return;
            }
            super.processMouseEvent(e);
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (!SearchTextField.this.hasIconsOutsideOfTextField() && SearchTextField.this.myClearFieldLabel != null) {
                SearchTextField.this.myClearFieldLabel.setBackground(bg);
            }
            if (SearchTextField.this.myToggleHistoryLabel != null) {
                SearchTextField.this.myToggleHistoryLabel.setBackground(bg);
            }
        }

        @Override
        public void setUI(TextUI ui) {
            if (SystemInfo.isMac) {
                try {
                    Class<?> uiClass = UIUtil.isUnderIntelliJLaF() ? Class.forName("com.intellij.ide.ui.laf.intellij.MacIntelliJTextFieldUI") : Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI");
                    Method method = ReflectionUtil.getMethod(uiClass, (String)"createUI", (Class[])new Class[]{JComponent.class});
                    if (method != null) {
                        super.setUI((TextUI)method.invoke(uiClass, this));
                        Class<?> borderClass = UIUtil.isUnderIntelliJLaF() ? Class.forName("com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder") : Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder");
                        this.setBorder((Border)ReflectionUtil.newInstance(borderClass));
                        this.setOpaque(false);
                    }
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.setUI(ui);
        }
    };
    private JBPopup myPopup;
    private JLabel myClearFieldLabel;
    private JLabel myToggleHistoryLabel;
    private JPopupMenu myNativeSearchPopup;
    private JMenuItem myNoItems;
    private String myHistoryPropertyName = null;

    public SearchTextField() {
        this(true);
    }

    public SearchTextField(boolean historyPopupEnabled) {
        this(historyPopupEnabled, null);
    }

    public SearchTextField(String historyPropertyName) {
        this(true, historyPropertyName);
    }

    public SearchTextField(boolean historyPopupEnabled, @Nullable String historyPropertyName) {
        super(new BorderLayout());
        ActionManager actionManager;
        this.myTextField.setColumns(15);
        this.myTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchTextField.this.onFocusLost();
                super.focusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchTextField.this.onFocusGained();
                super.focusGained(e);
            }
        });
        this.add((Component)this.myTextField, "Center");
        this.setHistoryPropertyName(historyPropertyName);
        if (historyPopupEnabled) {
            this.myTextField.getActionMap().put("showHistory", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchTextField.this.isSearchControlUISupported() && SearchTextField.this.myNativeSearchPopup != null) {
                        SearchTextField.this.myNativeSearchPopup.show(SearchTextField.this.myTextField, 5, SearchTextField.this.myTextField.getHeight());
                    } else if (SearchTextField.this.myPopup == null || !SearchTextField.this.myPopup.isVisible()) {
                        SearchTextField.this.showPopup();
                    }
                }
            });
            this.myTextField.getInputMap().put(SHOW_HISTORY_KEYSTROKE, "showHistory");
        } else if (historyPropertyName != null) {
            this.myTextField.getActionMap().put("showPrevHistoryItem", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SearchTextField.this.myModel.myFullList.contains(SearchTextField.this.getText())) {
                        SearchTextField.this.addCurrentTextToHistory();
                    }
                    if (SearchTextField.this.myModel.getSize() < 2) {
                        return;
                    }
                    SearchTextField.this.myCurrentHistoryIndex--;
                    if (SearchTextField.this.myCurrentHistoryIndex < 0) {
                        SearchTextField.this.myCurrentHistoryIndex = SearchTextField.this.myModel.getSize() - 1;
                    }
                    SearchTextField.this.setText(SearchTextField.this.myModel.getElementAt(SearchTextField.this.myCurrentHistoryIndex));
                }
            });
            this.myTextField.getInputMap().put(ALT_SHOW_HISTORY_KEYSTROKE, "showPrevHistoryItem");
            this.myTextField.getActionMap().put("showNextHistoryItem", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SearchTextField.this.myModel.myFullList.contains(SearchTextField.this.getText())) {
                        SearchTextField.this.addCurrentTextToHistory();
                    }
                    if (SearchTextField.this.myModel.getSize() < 2) {
                        return;
                    }
                    SearchTextField.this.myCurrentHistoryIndex++;
                    if (SearchTextField.this.myCurrentHistoryIndex > SearchTextField.this.myModel.getSize() - 1) {
                        SearchTextField.this.myCurrentHistoryIndex = 0;
                    }
                    SearchTextField.this.setText(SearchTextField.this.myModel.getElementAt(SearchTextField.this.myCurrentHistoryIndex));
                }
            });
            this.myTextField.getInputMap().put(SHOW_HISTORY_KEYSTROKE, "showNextHistoryItem");
        }
        if (this.isSearchControlUISupported()) {
            this.myTextField.putClientProperty("JTextField.variant", "search");
            this.myTextField.putClientProperty("JTextField.Search.CancelAction", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchTextField.this.myTextField.setText("");
                    SearchTextField.this.onFieldCleared();
                }
            });
            if (historyPopupEnabled) {
                this.myNativeSearchPopup = new JBPopupMenu();
                this.myNoItems = new JBMenuItem("No recent searches");
                this.myNoItems.setEnabled(false);
                this.updateMenu();
                this.myTextField.putClientProperty("JTextField.Search.FindPopup", this.myNativeSearchPopup);
            }
        } else {
            this.myToggleHistoryLabel = new JLabel(AllIcons.Actions.Search);
            this.myToggleHistoryLabel.setOpaque(true);
            this.myToggleHistoryLabel.setToolTipText("Search History (" + KeymapUtil.getKeystrokeText(SHOW_HISTORY_KEYSTROKE) + ")");
            this.myToggleHistoryLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchTextField.this.togglePopup();
                }
            });
            if (historyPopupEnabled) {
                this.add((Component)this.myToggleHistoryLabel, "West");
            }
            this.myClearFieldLabel = new JLabel(UIUtil.isUnderDarcula() ? AllIcons.Actions.Clean : AllIcons.Actions.CleanLight);
            this.myClearFieldLabel.setOpaque(true);
            this.add((Component)this.myClearFieldLabel, "East");
            this.myClearFieldLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchTextField.this.myTextField.setText("");
                    SearchTextField.this.onFieldCleared();
                }
            });
            if (!this.hasIconsOutsideOfTextField()) {
                Border originalBorder = SystemInfo.isMac ? BorderFactory.createLoweredBevelBorder() : this.myTextField.getBorder();
                this.myToggleHistoryLabel.setBackground(this.myTextField.getBackground());
                this.myClearFieldLabel.setBackground(this.myTextField.getBackground());
                this.setBorder(new CompoundBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)2, (int)0), originalBorder));
                this.myTextField.setOpaque(true);
                this.myTextField.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)5));
            } else {
                this.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)2, (int)0));
            }
        }
        if (this.toClearTextOnEscape() && (actionManager = ActionManager.getInstance()) != null) {
            EmptyAction.registerWithShortcutSet("TextComponent.ClearAction", CommonShortcuts.ESCAPE, this);
        }
    }

    protected boolean toClearTextOnEscape() {
        return ApplicationManager.getApplication() != null;
    }

    protected void onFieldCleared() {
    }

    protected void onFocusLost() {
        if (this.myHistoryPropertyName != null && this.myNativeSearchPopup == null && this.myPopup == null) {
            this.addCurrentTextToHistory();
        }
    }

    protected void onFocusGained() {
    }

    private void updateMenu() {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.removeAll();
            int itemsCount = this.myModel.getSize();
            if (itemsCount == 0) {
                this.myNativeSearchPopup.add(this.myNoItems);
            } else {
                for (int i2 = 0; i2 < itemsCount; ++i2) {
                    String item = this.myModel.getElementAt(i2);
                    this.addMenuItem(item);
                }
            }
        }
    }

    protected boolean isSearchControlUISupported() {
        return SystemInfo.isMacOSLeopard && UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF();
    }

    protected boolean hasIconsOutsideOfTextField() {
        return UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().removeDocumentListener(listener);
    }

    public void addKeyboardListener(KeyListener listener) {
        this.getTextEditor().addKeyListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myToggleHistoryLabel != null) {
            Color bg = enabled ? UIUtil.getTextFieldBackground() : UIUtil.getPanelBackground();
            this.myToggleHistoryLabel.setBackground(bg);
            this.myClearFieldLabel.setBackground(bg);
        }
    }

    public void setHistorySize(int historySize) {
        if (historySize <= 0) {
            throw new IllegalArgumentException("history size must be a positive number");
        }
        this.myHistorySize = historySize;
    }

    public void setHistory(List<String> aHistory) {
        this.myModel.setItems(aHistory);
    }

    public List<String> getHistory() {
        int itemsCount = this.myModel.getSize();
        ArrayList<String> history = new ArrayList<String>(itemsCount);
        for (int i2 = 0; i2 < itemsCount; ++i2) {
            history.add(this.myModel.getElementAt(i2));
        }
        return history;
    }

    public void setText(String aText) {
        this.getTextEditor().setText(aText);
    }

    public String getText() {
        return this.getTextEditor().getText();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.hidePopup();
    }

    public void addCurrentTextToHistory() {
        if (this.myNativeSearchPopup != null && this.myNativeSearchPopup.isVisible() || this.myPopup != null && this.myPopup.isVisible()) {
            return;
        }
        String item = this.getText();
        this.myModel.addElement(item);
        if (this.myHistoryPropertyName != null) {
            PropertiesComponent.getInstance().setValue(this.myHistoryPropertyName, StringUtil.join(this.getHistory(), (String)"\n"));
        }
    }

    private void addMenuItem(final String item) {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.remove(this.myNoItems);
            JBMenuItem menuItem = new JBMenuItem(item);
            this.myNativeSearchPopup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchTextField.this.myTextField.setText(item);
                    SearchTextField.this.addCurrentTextToHistory();
                }
            });
        }
    }

    public void selectText() {
        this.getTextEditor().selectAll();
    }

    public JBTextField getTextEditor() {
        return this.myTextField;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myTextField.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.getTextEditor(), true));
    }

    public void setHistoryPropertyName(String historyPropertyName) {
        this.myHistoryPropertyName = historyPropertyName;
        this.myTextField.putClientProperty("JTextField.Search.InplaceHistory", this.myHistoryPropertyName);
        this.reset();
    }

    public void reset() {
        if (this.myHistoryPropertyName == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String history = propertiesComponent.getValue(this.myHistoryPropertyName);
        if (history != null) {
            String[] items = history.split("\n");
            ArrayList<String> result = new ArrayList<String>();
            for (String item : items) {
                if (item == null || item.length() <= 0) continue;
                result.add(item);
            }
            this.setHistory(result);
        }
        this.setSelectedItem("");
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Border border = super.getBorder();
        if (border != null && UIUtil.isUnderAquaLookAndFeel()) {
            JBInsets.addTo((Dimension)size, (Insets)border.getBorderInsets(this));
        }
        return size;
    }

    protected Runnable createItemChosenCallback(JList list) {
        return () -> {
            String value = (String)list.getSelectedValue();
            this.getTextEditor().setText(value != null ? value : "");
            this.addCurrentTextToHistory();
            if (this.myPopup != null) {
                this.myPopup.cancel();
                this.myPopup = null;
            }
        };
    }

    protected void showPopup() {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            JBList list = new JBList(this.myModel);
            Runnable chooseRunnable = this.createItemChosenCallback(list);
            this.myPopup = JBPopupFactory.getInstance().createListPopupBuilder(list).setMovable(false).setRequestFocus(true).setItemChoosenCallback(chooseRunnable).createPopup();
            if (this.isShowing()) {
                this.myPopup.showUnderneathOf(this.getPopupLocationComponent());
            }
        }
    }

    protected Component getPopupLocationComponent() {
        return this.hasIconsOutsideOfTextField() ? this.myToggleHistoryLabel : this;
    }

    private void togglePopup() {
        if (this.myPopup == null) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    public void setSelectedItem(String s) {
        this.getTextEditor().setText(s);
    }

    public int getSelectedIndex() {
        return this.myModel.myFullList.indexOf(this.getText());
    }

    public final void keyEventToTextField(KeyEvent e) {
        this.myTextField.processKeyEvent(e);
    }

    protected boolean preprocessEventForTextField(KeyEvent e) {
        if (SHOW_HISTORY_KEYSTROKE.equals(KeyStroke.getKeyStrokeForEvent(e)) && this.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu) {
            this.showPopup();
            return true;
        }
        return false;
    }

    public void setSearchIcon(Icon icon) {
        if (!this.isSearchControlUISupported()) {
            this.myToggleHistoryLabel.setIcon(icon);
        }
    }

    public static final class FindAction
    extends DumbAwareAction {
        @Override
        public void actionPerformed(AnActionEvent event) {
            SearchTextField search = event.getData(KEY);
            if (search != null) {
                search.selectText();
                search.requestFocus();
            }
        }
    }

    protected static class TextFieldWithProcessing
    extends JBTextField {
        protected TextFieldWithProcessing() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }

    public class MyModel
    extends AbstractListModel {
        private List<String> myFullList = new ArrayList<String>();
        private String mySelectedItem;

        @Override
        public String getElementAt(int index) {
            return this.myFullList.get(index);
        }

        @Override
        public int getSize() {
            return Math.min(SearchTextField.this.myHistorySize, this.myFullList.size());
        }

        public void addElement(String item) {
            String newItem = item.trim();
            if (newItem.isEmpty()) {
                return;
            }
            int length = this.myFullList.size();
            int index = -1;
            for (int i2 = 0; i2 < length; ++i2) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)this.myFullList.get(i2), (CharSequence)newItem)) continue;
                index = i2;
                break;
            }
            if (index == 0) {
                return;
            }
            if (index > 0) {
                this.myFullList.remove(index);
            } else if (this.myFullList.size() >= SearchTextField.this.myHistorySize && this.myFullList.size() > 0) {
                this.myFullList.remove(this.myFullList.size() - 1);
            }
            this.insertElementAt(newItem, 0);
        }

        public void insertElementAt(String item, int index) {
            this.myFullList.add(index, item);
            this.fireContentsChanged();
        }

        public String getSelectedItem() {
            return this.mySelectedItem;
        }

        public void setSelectedItem(String anItem) {
            this.mySelectedItem = anItem;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
            SearchTextField.this.updateMenu();
        }

        public void setItems(List<String> aList) {
            this.myFullList = new ArrayList<String>(aList);
            this.fireContentsChanged();
        }
    }
}

