/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWithFilter<T>
extends JPanel
implements DataProvider {
    private final JList<T> myList;
    private final SearchTextField mySearchField;
    private final NameFilteringListModel<T> myModel;
    private final JScrollPane myScrollPane;
    private final MySpeedSearch mySpeedSearch;

    @Override
    public Object getData(@NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchField.getText();
        }
        return null;
    }

    public static <T> JComponent wrap(@NotNull JList<T> list, @NotNull JScrollPane scrollPane, @Nullable Function<T, String> namer) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(0);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(1);
        }
        return ListWithFilter.wrap(list, scrollPane, namer, false);
    }

    public static <T> JComponent wrap(@NotNull JList<T> list, @NotNull JScrollPane scrollPane, @Nullable Function<T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(2);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(3);
        }
        return new ListWithFilter<T>(list, scrollPane, namer, highlightAllOccurrences);
    }

    private ListWithFilter(@NotNull JList<T> list, @NotNull JScrollPane scrollPane, @Nullable Function<T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(4);
        }
        if (scrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        this.mySearchField = new SearchTextField(false);
        if (list instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)((Object)list)).getEmptyText().setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
        }
        this.myList = list;
        this.myScrollPane = scrollPane;
        this.mySearchField.getTextEditor().setFocusable(false);
        this.mySearchField.setVisible(false);
        this.add((Component)this.mySearchField, "North");
        this.add((Component)this.myScrollPane, "Center");
        this.mySpeedSearch = new MySpeedSearch(highlightAllOccurrences);
        this.mySpeedSearch.setEnabled(namer != null);
        this.myList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 65 && (e.isControlDown() || e.isMetaDown())) {
                    return;
                }
                ListWithFilter.this.mySpeedSearch.process(e);
            }
        });
        int selectedIndex = this.myList.getSelectedIndex();
        int modelSize = this.myList.getModel().getSize();
        this.myModel = new NameFilteringListModel<T>(this.myList, namer, (Condition<String>)((Condition)s -> this.mySpeedSearch.shouldBeShowing((String)s)), this.mySpeedSearch);
        if (this.myModel.getSize() == modelSize) {
            this.myList.setSelectedIndex(selectedIndex);
        }
        this.setBackground(list.getBackground());
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }
    }

    public boolean resetFilter() {
        boolean hadPattern = this.mySpeedSearch.isHoldingFilter();
        if (this.mySearchField.isVisible()) {
            this.mySpeedSearch.reset();
        }
        return hadPattern;
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSpeedSearchPatternChanged() {
        T prevSelection = this.myList.getSelectedValue();
        this.myModel.refilter();
        if (this.myModel.getSize() > 0) {
            int fullMatchIndex;
            int n = fullMatchIndex = this.mySpeedSearch.isHoldingFilter() ? this.myModel.getClosestMatchIndex() : this.myModel.getElementIndex(prevSelection);
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myModel.getSize() <= this.myList.getSelectedIndex() || !this.myModel.contains(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        } else {
            this.mySpeedSearch.noHits();
            this.revalidate();
        }
    }

    public JList getList() {
        return this.myList;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/speedSearch/ListWithFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MySpeedSearch
    extends SpeedSearch {
        boolean searchFieldShown;
        boolean myInUpdate;

        private MySpeedSearch(boolean highlightAllOccurrences) {
            super(highlightAllOccurrences);
            ListWithFilter.this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MySpeedSearch.this.myInUpdate) {
                        return;
                    }
                    if (ListWithFilter.this.mySearchField.getText().isEmpty()) {
                        ListWithFilter.this.mySpeedSearch.reset();
                    }
                }
            });
            this.installSupplyTo(ListWithFilter.this.myList);
        }

        @Override
        public void update() {
            this.myInUpdate = true;
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            ListWithFilter.this.onSpeedSearchPatternChanged();
            ListWithFilter.this.mySearchField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(true);
                this.searchFieldShown = true;
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                ListWithFilter.this.mySearchField.setVisible(false);
                this.searchFieldShown = false;
            }
            this.myInUpdate = false;
            this.revalidate();
        }

        @Override
        public void noHits() {
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(LightColors.RED);
        }

        private void revalidate() {
            JBPopup popup = PopupUtil.getPopupContainerFor(ListWithFilter.this.mySearchField);
            if (popup != null) {
                popup.pack(false, true);
            }
            ListWithFilter.this.revalidate();
        }
    }
}

