/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition;
    private final AtomicReference<Usage> myFirstUsage;
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewImpl> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Factory<UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages;

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project, @NotNull AtomicReference<UsageViewImpl> usageViewRef, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (usageViewManager == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(1);
        }
        if (usageViewRef == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(3);
        }
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(4);
        }
        if (searcherFactory == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(5);
        }
        if (processPresentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(6);
        }
        if (searchScopeToWarnOfFallingOutOf == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(7);
        }
        this.myUsageCountWithoutDefinition = new AtomicInteger(0);
        this.myFirstUsage = new AtomicReference();
        this.myOutOfScopeUsages = new AtomicInteger();
        this.myProject = project;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener;
        this.myUsageViewManager = usageViewManager;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget[] searchFor) {
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        String string = "<a href='FindOptions'>Find Options...</a>" + shortcutText;
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        if ("<a href='SearchInProject'>Search in Project</a>" == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(9);
        }
        return "<a href='SearchInProject'>Search in Project</a>";
    }

    private void notifyByFindBalloon(@Nullable HyperlinkListener listener, @NotNull MessageType messageType, @NotNull List<String> lines) {
        Runnable searchIncludingProjectFileUsages;
        if (messageType == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(10);
        }
        if (lines == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(11);
        }
        com.intellij.usageView.UsageViewManager.getInstance(this.myProject);
        Collection<VirtualFile> largeFiles = this.myProcessPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, () -> {
                if (lines == null) {
                    SearchForUsagesRunnable.$$$reportNull$$$0(36);
                }
                if (messageType == null) {
                    SearchForUsagesRunnable.$$$reportNull$$$0(37);
                }
                String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                ArrayList<String> strings = new ArrayList<String>(lines);
                strings.add(detailedMessage);
                ToolWindowManager.getInstance(this.myProject).notifyByBalloon(ToolWindowId.FIND, messageType, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener);
            });
        }
        if ((searchIncludingProjectFileUsages = this.myProcessPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add("Occurrences in project configuration files are skipped. <a href='SHOW_PROJECT_FILE_OCCURRENCES'>Include them</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        Collection<UnloadedModuleDescription> unloaded = this.getUnloadedModulesBelongingToScope();
        MessageType actualType = messageType;
        if (!unloaded.isEmpty()) {
            if (actualType == MessageType.INFO) {
                actualType = MessageType.WARNING;
            }
            resultLines.add(SearchForUsagesRunnable.mayHaveUsagesInUnloadedModulesMessage(unloaded));
        }
        ToolWindowManager.getInstance(this.myProject).notifyByBalloon(ToolWindowId.FIND, actualType, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    private Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return (Collection)ReadAction.compute(() -> {
            if (!(this.mySearchScopeToWarnOfFallingOutOf instanceof GlobalSearchScope)) {
                return Collections.emptySet();
            }
            Collection<UnloadedModuleDescription> unloadedInSearchScope = ((GlobalSearchScope)this.mySearchScopeToWarnOfFallingOutOf).getUnloadedModulesBelongingToScope();
            Set<UnloadedModuleDescription> unloadedInUseScope = this.getUnloadedModulesBelongingToUseScopes();
            if (unloadedInUseScope != null) {
                return ContainerUtil.intersection(unloadedInSearchScope, unloadedInUseScope);
            }
            return unloadedInSearchScope;
        });
    }

    private Set<UnloadedModuleDescription> getUnloadedModulesBelongingToUseScopes() {
        LinkedHashSet<UnloadedModuleDescription> resolveScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (UsageTarget target : this.mySearchFor) {
            if (!(target instanceof PsiElementUsageTarget)) {
                return null;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null) {
                return null;
            }
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            resolveScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return resolveScope;
    }

    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener, final @NotNull String hrefTarget, final @NotNull Runnable handler) {
        if (hrefTarget == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(12);
        }
        if (handler == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(13);
        }
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(hrefTarget)) {
                    handler.run();
                } else if (listener != null) {
                    listener.hyperlinkUpdate(e);
                }
            }
        };
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        if (strings == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(14);
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<VirtualFile> largeFiles) {
        if (largeFiles == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(16);
        }
        String message = "";
        if (largeFiles.size() == 1) {
            VirtualFile vFile = largeFiles.iterator().next();
            message = message + "File " + SearchForUsagesRunnable.presentableFileInfo(vFile) + " is ";
        } else {
            message = message + "Files<br> ";
            int counter = 0;
            for (VirtualFile vFile : largeFiles) {
                message = message + SearchForUsagesRunnable.presentableFileInfo(vFile) + "<br> ";
                if (counter++ <= 10) continue;
                break;
            }
            message = message + "are ";
        }
        String string = message = message + "too large and cannot be scanned";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(18);
        }
        String string = SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(20);
        }
        String string = "'" + (String)ReadAction.compute(virtualFile2::getPresentableUrl) + "'";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final @NotNull UsageTarget[] targets) {
        if (targets == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(22);
        }
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(SearchForUsagesRunnable.FIND_OPTIONS_HREF_TARGET)) {
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                        if (targets == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        FindManager.getInstance(SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages(targets);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/SearchForUsagesRunnable$2", "lambda$hyperlinkActivated$0"));
            }
        };
        if (hyperlinkAdapter == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(23);
        }
        return hyperlinkAdapter;
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                PsiElement psiElement;
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> FindManager.getInstance(SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, GlobalSearchScope.projectScope(SearchForUsagesRunnable.this.myProject)));
                }
            }
        };
        if (hyperlinkAdapter == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(24);
        }
        return hyperlinkAdapter;
    }

    private static PsiElement getPsiElement(@NotNull UsageTarget[] searchFor) {
        UsageTarget target;
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(25);
        }
        if (!((target = searchFor[0]) instanceof PsiElementUsageTarget)) {
            return null;
        }
        return (PsiElement)ReadAction.compute(((PsiElementUsageTarget)target)::getElement);
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (usage == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(26);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Processor processor = Processors.cancelableCollectProcessor(segments);
        usageInfo.processRangeMarkers(processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private UsageViewImpl getUsageView(@NotNull ProgressIndicator indicator) {
        UsageViewImpl usageView;
        if (indicator == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(27);
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            return usageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            usageView = new UsageViewImpl(this.myProject, this.myPresentation, this.mySearchFor, this.mySearcherFactory);
            usageView.associateProgress(indicator);
            if (this.myUsageViewRef.compareAndSet(null, usageView)) {
                this.openView(usageView);
                Usage firstUsage = this.myFirstUsage.get();
                if (firstUsage != null) {
                    UsageViewImpl finalUsageView = usageView;
                    ApplicationManager.getApplication().runReadAction(() -> finalUsageView.appendUsage(firstUsage));
                }
            } else {
                UsageViewImpl finalUsageView = usageView;
                UIUtil.invokeLaterIfNeeded(() -> Disposer.dispose((Disposable)finalUsageView));
            }
            return this.myUsageViewRef.get();
        }
        return null;
    }

    private void openView(@NotNull UsageViewImpl usageView) {
        if (usageView == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(28);
        }
        SwingUtilities.invokeLater(() -> {
            if (usageView == null) {
                SearchForUsagesRunnable.$$$reportNull$$$0(35);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myUsageViewManager.addContent(usageView, this.myPresentation);
            if (this.myListener != null) {
                this.myListener.usageViewCreated(usageView);
            }
            this.myUsageViewManager.showToolWindow(false);
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        this.searchUsages(findUsagesStartedShown);
        this.endSearchForUsages(findUsagesStartedShown);
        snapshot.logResponsivenessSinceCreation("Find Usages");
    }

    private void searchUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        ProgressIndicator indicator;
        if (findStartedBalloonShown == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(29);
        }
        if ((indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator())) == null) {
            throw new IllegalStateException("must run find usages under progress");
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.assertUnderProgress((ProgressIndicator)indicator);
        }
        TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
        Alarm findUsagesStartedBalloon = new Alarm();
        findUsagesStartedBalloon.addRequest(() -> {
            if (findStartedBalloonShown == null) {
                SearchForUsagesRunnable.$$$reportNull$$$0(34);
            }
            this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList(StringUtil.escapeXml((String)UsageViewManagerImpl.getProgressTitle(this.myPresentation))));
            findStartedBalloonShown.set(true);
        }, 300, ModalityState.NON_MODAL);
        UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
        usageSearcher.generate((Processor<Usage>)((Processor)usage -> {
            boolean incrementCounter;
            ProgressIndicator indicator1 = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            if (indicator1 == null) {
                throw new IllegalStateException("must run find usages under progress");
            }
            if (indicator1.isCanceled()) {
                return false;
            }
            if (!UsageViewManagerImpl.isInScope(usage, this.mySearchScopeToWarnOfFallingOutOf)) {
                this.myOutOfScopeUsages.incrementAndGet();
                return true;
            }
            boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, this.mySearchFor);
            if (incrementCounter) {
                int usageCount = this.myUsageCountWithoutDefinition.incrementAndGet();
                if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                    this.myFirstUsage.compareAndSet((Usage)null, (Usage)usage);
                }
                UsageViewImpl usageView = this.getUsageView(indicator1);
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)indicator1);
                if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    UsageViewManagerImpl.showTooManyUsagesWarningLater(this.myProject, tooManyUsagesStatus, indicator1, this.myPresentation, usageCount, usageView);
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                if (usageView != null) {
                    ApplicationManager.getApplication().runReadAction(() -> usageView.appendUsage((Usage)usage));
                }
            }
            return !indicator1.isCanceled();
        }));
        if (this.getUsageView(indicator) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.myUsageViewManager.showToolWindow(true), this.myProject.getDisposed());
        }
        Disposer.dispose((Disposable)findUsagesStartedBalloon);
        ApplicationManager.getApplication().invokeLater(() -> {
            Balloon balloon;
            if (findStartedBalloonShown == null) {
                SearchForUsagesRunnable.$$$reportNull$$$0(33);
            }
            if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(this.myProject).getToolWindowBalloon(ToolWindowId.FIND)) != null) {
                balloon.hide();
            }
        }, this.myProject.getDisposed());
    }

    private void endSearchForUsages(final @NotNull AtomicBoolean findStartedBalloonShown) {
        if (findStartedBalloonShown == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(30);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0 && this.myProcessPresentation.isShowNotFoundMessage()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchForUsagesRunnable.this.myProcessPresentation.isCanceled()) {
                        SearchForUsagesRunnable.this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList("Usage search was canceled"));
                        findStartedBalloonShown.set(false);
                        return;
                    }
                    String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize((String)SearchForUsagesRunnable.this.myPresentation.getUsagesString()), SearchForUsagesRunnable.this.myPresentation.getScopeText(), SearchForUsagesRunnable.this.myPresentation.getContextText());
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(StringUtil.escapeXml((String)message));
                    if (SearchForUsagesRunnable.this.myOutOfScopeUsages.get() != 0) {
                        lines.add(UsageViewManagerImpl.outOfScopeMessage(SearchForUsagesRunnable.this.myOutOfScopeUsages.get(), SearchForUsagesRunnable.this.mySearchScopeToWarnOfFallingOutOf));
                    }
                    if (SearchForUsagesRunnable.this.myProcessPresentation.isShowFindOptionsPrompt()) {
                        lines.add(SearchForUsagesRunnable.createOptionsHtml(SearchForUsagesRunnable.this.mySearchFor));
                    }
                    MessageType type = SearchForUsagesRunnable.this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    SearchForUsagesRunnable.this.notifyByFindBalloon(SearchForUsagesRunnable.this.createGotToOptionsListener(SearchForUsagesRunnable.this.mySearchFor), type, lines);
                    findStartedBalloonShown.set(false);
                }
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Usage usage = this.myFirstUsage.get();
                if (usage.canNavigate()) {
                    usage.navigate(true);
                    SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("Only one usage found.");
                if (this.myOutOfScopeUsages.get() != 0) {
                    lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                }
                lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            UsageViewImpl usageView = this.myUsageViewRef.get();
            if (usageView != null) {
                usageView.drainQueuedUsageNodes();
                usageView.setSearchInProgress(false);
            }
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null || !this.getUnloadedModulesBelongingToScope().isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(hyperlinkListener, type, lines);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(this.myUsageViewRef.get());
        }
    }

    @NotNull
    private static String mayHaveUsagesInUnloadedModulesMessage(@NotNull Collection<UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(31);
        }
        String modulesText = unloadedModules.size() > 1 ? unloadedModules.size() + " unloaded modules" : "unloaded module '" + ((UnloadedModuleDescription)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(unloadedModules))).getName() + "'";
        String string = "Occurrences in " + modulesText + " may be skipped. Load all modules and repeat the search to get complete results.";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopeToWarnOfFallingOutOf";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 10: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 11: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hrefTarget";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "largeFiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findStartedBalloonShown";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsHtml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchInProjectHtml";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "detailedLargeFilesMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableFileInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createGotToOptionsListener";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchInProjectListener";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 32: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyByFindBalloon";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHrefHandling";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "detailedLargeFilesMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "presentableFileInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createGotToOptionsListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "flashUsageScriptaculously";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUsageView";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "openView";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "searchUsages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "endSearchForUsages";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchUsages$9";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchUsages$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openView$4";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyByFindBalloon$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

