/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.AnimatedIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AsyncProcessIcon
extends AnimatedIcon {
    public static final int COUNT = 12;
    public static final int CYCLE_LENGTH = 800;
    private static final Icon[] SMALL_ICONS = AsyncProcessIcon.findIcons("/process/step_", "/process/step_mask.png");
    private boolean myUseMask;

    public AsyncProcessIcon(@NonNls String name) {
        this(name, SMALL_ICONS, AllIcons.Process.Step_passive);
    }

    public AsyncProcessIcon(@NonNls String name, Icon[] icons, Icon passive) {
        super(name, icons, passive, 800);
        this.setUseMask(false);
    }

    public AsyncProcessIcon setUseMask(boolean useMask) {
        this.myUseMask = useMask;
        return this;
    }

    @Override
    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        if (icon instanceof ProcessIcon) {
            ((ProcessIcon)((Object)icon)).setLayerEnabled(0, this.myUseMask);
        }
        super.paintIcon(g, icon, x, y);
        if (icon instanceof ProcessIcon) {
            ((ProcessIcon)((Object)icon)).setLayerEnabled(0, false);
        }
    }

    private static Icon[] findIcons(String prefix, String maskIconPath) {
        Icon maskIcon = maskIconPath != null ? IconLoader.getIcon((String)maskIconPath) : null;
        Icon[] icons = new Icon[12];
        for (int i2 = 0; i2 <= 11; ++i2) {
            Icon eachIcon = IconLoader.getIcon((String)(prefix + (i2 + 1) + ".png"));
            icons[i2] = maskIcon != null ? new ProcessIcon(maskIcon, eachIcon) : eachIcon;
        }
        return icons;
    }

    public void updateLocation(JComponent container) {
        Rectangle newBounds = this.calculateBounds(container);
        if (!newBounds.equals(this.getBounds())) {
            this.setBounds(newBounds);
            SwingUtilities.invokeLater(() -> container.repaint());
        }
    }

    @NotNull
    protected Rectangle calculateBounds(@NotNull JComponent container) {
        if (container == null) {
            AsyncProcessIcon.$$$reportNull$$$0(0);
        }
        Rectangle rec = container.getVisibleRect();
        Dimension iconSize = this.getPreferredSize();
        Rectangle rectangle = new Rectangle(rec.x + rec.width - iconSize.width, rec.y, iconSize.width, iconSize.height);
        if (rectangle == null) {
            AsyncProcessIcon.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    public boolean isDisposed() {
        return this.myAnimator.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/AsyncProcessIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/AsyncProcessIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateBounds";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Big
    extends AsyncProcessIcon {
        private static final Icon[] BIG_ICONS = new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8, AllIcons.Process.Big.Step_9, AllIcons.Process.Big.Step_10, AllIcons.Process.Big.Step_11, AllIcons.Process.Big.Step_12};

        public Big(@NonNls String name) {
            super(name, BIG_ICONS, AllIcons.Process.Big.Step_passive);
        }
    }

    private static class ProcessIcon
    extends LayeredIcon {
        private ProcessIcon(Icon mask, Icon stepIcon) {
            super(mask, stepIcon);
        }
    }
}

