/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlVariantsProcessor;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlDynamicMember;
import com.intellij.freemarker.psi.variables.FtlLightParameter;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlPsiType
extends FtlType {
    public static final Key<Boolean> STATIC_ERROR = Key.create((String)"STATIC_ERROR");
    private final PsiType myPsiType;
    private final boolean myStatic;

    public FtlPsiType(PsiType psiType, boolean aStatic) {
        this.myPsiType = psiType;
        this.myStatic = aStatic;
    }

    public FtlPsiType(@NotNull PsiType psiType) {
        if (psiType == null) {
            FtlPsiType.$$$reportNull$$$0(0);
        }
        this(psiType, false);
    }

    @NotNull
    public PsiType getPsiType() {
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            FtlPsiType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlPsiType)) {
            return false;
        }
        FtlPsiType that = (FtlPsiType)o;
        return !(this.myPsiType != null ? !this.myPsiType.equals(that.myPsiType) : that.myPsiType != null);
    }

    public int hashCode() {
        return this.myPsiType != null ? this.myPsiType.hashCode() : 0;
    }

    @Nullable
    public static FtlPsiType wrap(@Nullable PsiType type) {
        return type == null ? null : new FtlPsiType(type);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
        if (processor == null) {
            FtlPsiType.$$$reportNull$$$0(2);
        }
        if (place == null) {
            FtlPsiType.$$$reportNull$$$0(3);
        }
        if (state.get(FtlQualifiedReference.RESOLVING_MACRO) == Boolean.TRUE) {
            return true;
        }
        if (this.myPsiType instanceof PsiClassType) {
            String hint;
            PsiClassType classType = (PsiClassType)this.myPsiType;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Map")) {
                return true;
            }
            ResolveState newState = state.put(PsiSubstitutor.KEY, (Object)resolveResult.getSubstitutor());
            String string = hint = processor instanceof FtlVariantsProcessor ? ((FtlVariantsProcessor)processor).getReferenceName() : null;
            if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, hint), newState, null, place)) {
                return false;
            }
            if (hint != null && !((FtlVariantsProcessor)processor).isMethodCall()) {
                String isAccessor = PropertyUtil.suggestGetterName((String)hint, (PsiType)PsiType.BOOLEAN);
                if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, isAccessor), newState, null, place)) {
                    return false;
                }
                String getAccessor = PropertyUtil.suggestGetterName((String)hint, (PsiType)PsiType.INT);
                if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, getAccessor), newState, null, place)) {
                    return false;
                }
            }
        }
        if (this.myStatic) {
            return true;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)place);
        if (module == null) {
            return true;
        }
        for (FtlFile file : FtlFile.getImplicitlyIncludedFiles(module)) {
            PsiFile javaFile = file.getViewProvider().getPsi(StdLanguages.JAVA);
            if (!(javaFile instanceof PsiJavaFile)) continue;
            for (PsiClass aClass : ((PsiJavaFile)javaFile).getClasses()) {
                for (PsiMethod method : aClass.getMethods()) {
                    FtlDynamicMember prop;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length <= 0 || !parameters[0].getType().isAssignableFrom(this.myPsiType)) continue;
                    FtlParameter[] ftlParameters = new FtlParameter[parameters.length - 1];
                    for (int i = 1; i < parameters.length; ++i) {
                        PsiParameter parameter = parameters[i];
                        ftlParameters[i - 1] = new FtlLightParameter(StringUtil.notNullize((String)parameter.getName()), (PsiElement)parameter, FtlPsiType.wrap(parameter.getType()));
                    }
                    final FtlPsiType returnType = FtlPsiType.wrap(method.getReturnType());
                    FtlDynamicMember variable = new FtlDynamicMember(method.getName(), method, (FtlType)new FtlCallableType(false, ftlParameters){

                        @Override
                        public FtlType getResultType() {
                            return returnType;
                        }
                    });
                    if (!processor.execute((PsiElement)variable, state)) {
                        return false;
                    }
                    if (!PropertyUtil.hasGetterName((PsiMethod)method) || parameters.length != 1 || processor.execute((PsiElement)(prop = new FtlDynamicMember(PropertyUtil.getPropertyNameByGetter((PsiMethod)method), method, (FtlType)returnType)), state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getPresentableText() {
        return this.myPsiType.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/variables/FtlPsiType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/variables/FtlPsiType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PsiMemberProcessor
    extends BaseScopeProcessor
    implements NameHint {
        private final PsiScopeProcessor myDelegate;
        private final String myNameHint;

        public PsiMemberProcessor(PsiScopeProcessor delegate, String hint) {
            this.myDelegate = delegate;
            this.myNameHint = hint;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                PsiMemberProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                PsiMemberProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                if (FtlPsiType.this.myStatic && !member.hasModifierProperty("static")) {
                    return this.myDelegate.execute(element, state.put(STATIC_ERROR, (Object)Boolean.TRUE));
                }
            }
            return this.myDelegate.execute(element, state);
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                PsiMemberProcessor.$$$reportNull$$$0(2);
            }
            if (hintKey == NameHint.KEY && this.myNameHint != null) {
                return (T)((Object)this);
            }
            return null;
        }

        @Nullable
        public String getName(@NotNull ResolveState state) {
            if (state == null) {
                PsiMemberProcessor.$$$reportNull$$$0(3);
            }
            return this.myNameHint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/freemarker/psi/variables/FtlPsiType$PsiMemberProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

