/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModelSearchParameters {
    private static final Map<String, BeanName> ourCachedBeanNames = ConcurrentFactoryMap.createMap(x$0 -> new BeanName((String)x$0), ContainerUtil::createConcurrentWeakKeyWeakValueMap);

    protected SpringModelSearchParameters() {
    }

    public abstract boolean canSearch();

    public static BeanClass byClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(0);
        }
        return new BeanClass(psiClass);
    }

    public static BeanClass byType(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(1);
        }
        return new BeanClass(psiType);
    }

    public static BeanName byName(@NotNull String beanName) {
        if (beanName == null) {
            SpringModelSearchParameters.$$$reportNull$$$0(2);
        }
        return ourCachedBeanNames.get(beanName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "byClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "byType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "byName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BeanName
    extends SpringModelSearchParameters {
        @NotNull
        private final String myBeanName;

        private BeanName(@NotNull String beanName) {
            if (beanName == null) {
                BeanName.$$$reportNull$$$0(0);
            }
            this.myBeanName = StringUtil.isNotEmpty((String)beanName) ? beanName : "";
        }

        @Override
        public boolean canSearch() {
            return !this.myBeanName.isEmpty();
        }

        @NotNull
        public String getBeanName() {
            String string = this.myBeanName;
            if (string == null) {
                BeanName.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanName)) {
                return false;
            }
            BeanName name = (BeanName)o;
            return this.myBeanName.equals(name.myBeanName);
        }

        public int hashCode() {
            return this.myBeanName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/SpringModelSearchParameters$BeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters$BeanName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BeanClass
    extends SpringModelSearchParameters {
        private final PsiType myType;
        private byte myOptions;
        private static final byte CAN_SEARCH = 1;
        private static final byte WITH_INHERITORS = 2;
        private static final byte EFFECTIVE_BEAN_TYPES = 4;

        private BeanClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                BeanClass.$$$reportNull$$$0(0);
            }
            BeanClass.assertSearchClass(psiClass);
            this.myType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)1, (boolean)SpringCommonUtils.isSpringBeanCandidateClass(psiClass));
        }

        private BeanClass(@NotNull PsiType psiType) {
            if (psiType == null) {
                BeanClass.$$$reportNull$$$0(1);
            }
            this.myType = psiType;
            PsiClass searchClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
            BeanClass.assertSearchClass(searchClass);
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)1, (searchClass == null || SpringCommonUtils.isSpringBeanCandidateClass(searchClass) ? 1 : 0) != 0);
        }

        private static void assertSearchClass(@Nullable PsiClass psiClass) {
            if (!ApplicationManager.getApplication().isInternal()) {
                return;
            }
            assert (!(psiClass instanceof PsiAnonymousClass)) : "no anon: " + psiClass;
            assert (psiClass == null || psiClass.getQualifiedName() != null) : "FQN is null: " + psiClass;
        }

        @Override
        public boolean canSearch() {
            return BitUtil.isSet((byte)this.myOptions, (byte)1);
        }

        public BeanClass withInheritors() {
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)2, (boolean)true);
            return this;
        }

        public BeanClass effectiveBeanTypes() {
            this.myOptions = BitUtil.set((byte)this.myOptions, (byte)4, (boolean)true);
            return this;
        }

        @NotNull
        public PsiType getSearchType() {
            PsiType psiType = this.myType;
            if (psiType == null) {
                BeanClass.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        public boolean isWithInheritors() {
            return BitUtil.isSet((byte)this.myOptions, (byte)2);
        }

        public boolean isEffectiveBeanTypes() {
            return BitUtil.isSet((byte)this.myOptions, (byte)4);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanClass)) {
                return false;
            }
            BeanClass beanClass = (BeanClass)o;
            if (this.myOptions != beanClass.myOptions) {
                return false;
            }
            if (!this.myType.isValid() || !beanClass.getSearchType().isValid()) {
                return false;
            }
            return this.myType.equals(beanClass.getSearchType());
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myOptions;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/SpringModelSearchParameters$BeanClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/SpringModelSearchParameters$BeanClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

