/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;

public abstract class SpringBeanMethodConverter
extends PsiMethodConverter {
    @Override
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(final ConvertContext context, final boolean forCompletion) {
        return new PsiMethodConverter.MethodAccepter(){

            @Override
            public boolean accept(PsiMethod method) {
                if (method.isConstructor()) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                String containing = containingClass.getQualifiedName();
                if ("java.lang.Object".equals(containing)) {
                    return false;
                }
                return SpringBeanMethodConverter.this.checkParameterList(method) && SpringBeanMethodConverter.this.checkModifiers(method) && SpringBeanMethodConverter.this.checkReturnType(context, method, forCompletion);
            }
        };
    }

    protected boolean checkModifiers(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.hasModifierProperty("abstract");
    }

    protected boolean checkParameterList(PsiMethod method) {
        return method.getParameterList().getParametersCount() == 0;
    }

    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        return true;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        PsiClass beanClass = this.getPsiClass(context);
        if (elementName != null && elementName.length() > 0 && beanClass != null) {
            LocalQuickFix[] localQuickFixArray;
            CreateMethodFix fix = CreateMethodFix.createVoidMethodIfFixPossible((PsiClass)beanClass, (String)elementName, (JvmModifier)JvmModifier.PRIVATE);
            if (fix == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            }
            return localQuickFixArray;
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Override
    protected String getMethodIdentificator(PsiMethod method) {
        return method.getName();
    }

    @Override
    protected PsiMethod[] getMethodCandidates(String methodIdentificator, PsiClass psiClass) {
        return MethodResolveProcessor.findMethod((PsiClass)psiClass, (String)methodIdentificator);
    }
}

