/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.managedbean.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.managedbean.ManagedBeanService;
import com.intellij.javaee.model.common.managedbean.ManagedBean;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ManagedBeanClassInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.JAVAEE_GROUP_NAME;
        if (string == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Managed Bean Class Inspection" == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(2);
        }
        return "Managed Bean Class Inspection";
    }

    @NotNull
    public String getShortName() {
        if ("ManagedBeanClassInspection" == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(3);
        }
        return "ManagedBeanClassInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ManagedBean bean;
        if (aClass == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(5);
        }
        if ((bean = ManagedBeanService.getInstance((Project)aClass.getProject()).getManagedBean(aClass)) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        EjbHighlightUtil.checkClassIsInterface(holder, aClass, false);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "final", false);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "abstract", false);
        if (aClass.getContainingClass() != null) {
            EjbHighlightUtil.checkClassModifier(holder, aClass, "static", true);
        }
        return holder.getResultsArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

