/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.common.persistence.mapping.NamedQuery;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaQueryReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            String queryName = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
            List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            PsiReference[] psiReferenceArray = new PsiReference[]{new QueryReference(element, queryName, facets)};
            if (psiReferenceArray == null) {
                JpaQueryReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(4);
        }
        return JamCommonUtil.getModelObject((PsiElement)target) instanceof NamedQuery;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryReference
    extends QueryRelatedReference {
        private final String myQueryName;
        private final List<PersistenceFacet> myFacets;
        private String myLocalName;

        public QueryReference(PsiElement element, String queryName, List<PersistenceFacet> facets) {
            super(element);
            this.myQueryName = queryName;
            this.myFacets = facets;
        }

        @Nullable
        public PersistenceQuery resolveQuery() {
            PersistenceQuery query;
            if (StringUtil.isEmpty((String)this.myQueryName)) {
                return null;
            }
            this.myLocalName = null;
            CommonProcessors.FindFirstProcessor<PersistenceQuery> processor = new CommonProcessors.FindFirstProcessor<PersistenceQuery>(){

                public boolean process(PersistenceQuery persistenceQuery) {
                    return !Comparing.equal((String)myQueryName, (String)((String)persistenceQuery.getName().getValue()), (boolean)true) || super.process((Object)persistenceQuery);
                }
            };
            PersistenceRoleHolder roleHolder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.myFacets) {
                if (!roleHolder.processMergedQueries(facet, (Processor)processor)) break;
            }
            PersistenceQuery persistenceQuery = query = processor.isFound() ? (PersistenceQuery)processor.getFoundValue() : null;
            if (query != null) {
                this.myLocalName = query.getName().getStringValue();
            }
            return query;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String text = this.getRangeInElement().substring(this.myElement.getText());
            String realNewName = text.endsWith(this.myLocalName) && text.length() > this.myLocalName.length() ? text.substring(0, text.length() - this.myLocalName.length()) + newElementName : newElementName;
            return super.handleElementRename(realNewName);
        }

        public PsiElement resolve() {
            PersistenceQuery persistenceQuery = this.resolveQuery();
            return persistenceQuery == null ? null : persistenceQuery.getIdentifyingPsiElement();
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList result = new ArrayList();
            Processor processor = persistenceQuery -> {
                String name = (String)persistenceQuery.getName().getValue();
                if (StringUtil.isNotEmpty((String)name)) {
                    String query = (String)persistenceQuery.getQuery().getValue();
                    LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                    if (StringUtil.isNotEmpty((String)query)) {
                        int maxDisplayChars = 30;
                        String text = query.length() < maxDisplayChars ? query : query.substring(0, maxDisplayChars) + "...";
                        lookupItem = lookupItem.withTypeText(text);
                    }
                    result.add(lookupItem);
                }
                return true;
            };
            PersistenceRoleHolder holder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet facet : this.myFacets) {
                if (!holder.processMergedQueries(facet, processor)) break;
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                QueryReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.0", (Object[])new Object[0]);
            if (string == null) {
                QueryReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class QueryRelatedReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public QueryRelatedReference(PsiElement element) {
            super(element, false);
        }

        public LocalQuickFix[] getQuickFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

