/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaDataSourceORMInspection;
import com.intellij.jpa.highlighting.JpaDomFacetInspection;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.converters.QuotedValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ORMReferencesUtil {
    public static final Function<DbColumn, String> COLUMN_MAPPER = s -> s.getName();
    public static final Function<DbTable, LookupElement> TABLE_LOOKUP_MAPPER = s -> {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)s);
        String kindName = DbPresentation.getPresentableName((ObjectKind)s.getKind(), (DatabaseDialect)dialect);
        return LookupElementBuilder.create((PsiNamedElement)s).withIcon(s.getIcon()).withTypeText(kindName).withCaseSensitivity(false);
    };
    public static final Function<DbColumn, LookupElement> COLUMN_LOOKUP_MAPPER = s -> {
        String typeName = s.getDataType().getSpecification();
        return LookupElementBuilder.create((PsiNamedElement)s).withIcon(s.getIcon()).withTypeText(typeName).withCaseSensitivity(false);
    };
    public static final Function<DbElement, LookupElement> CATALOG_LOOKUP_MAPPER = s -> LookupElementBuilder.create((PsiNamedElement)s).withCaseSensitivity(false);
    public static final Function<DbElement, LookupElement> SCHEMA_LOOKUP_MAPPER = s -> LookupElementBuilder.create((PsiNamedElement)s).withCaseSensitivity(false);
    public static final TableInfo NO_TABLE_INFO = new TableInfo("", "", "");
    private static final Function<DasObject, String> DB_ELEMENT_NAME_MAPPER = DasUtil.TO_NAME;

    private ORMReferencesUtil() {
    }

    @Nullable
    public static PsiClass getEntityClass(PsiMember member, boolean target) {
        for (PersistentAttribute attribute : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
            if (!(attribute instanceof PersistentRelationshipAttribute)) continue;
            PersistentRelationshipAttribute relationAttr = (PersistentRelationshipAttribute)attribute;
            if (relationAttr.getAttributeModelHelper().isInverseSide()) {
                return target ? ORMReferencesUtil.getTargetClass((PsiElement)member) : PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)relationAttr);
            }
            return target ? PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)relationAttr) : ORMReferencesUtil.getTargetClass((PsiElement)member);
        }
        return target ? null : ORMReferencesUtil.getTargetClass((PsiElement)member);
    }

    public static <T> Collection<DbTable> getColumnTableVariants(Collection<DbDataSource> dataSources, List<T> roles, Function<T, PersistentEntity> entityMapper) {
        if (dataSources.isEmpty()) {
            return Collections.emptyList();
        }
        BidirectionalMap tableMap = new BidirectionalMap();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<DbDataSource, DasObject>)((PairProcessor)(db, table) -> {
            tableMap.put((Object)((DbTable)DbImplUtil.findElement((DbDataSource)db, (DasObject)table)), (Object)table.getName().toUpperCase(Locale.ENGLISH));
            return true;
        }));
        if (roles.size() == 0) {
            return tableMap.keySet();
        }
        Function function = s -> {
            List list = s == null ? null : tableMap.getKeysByValue((Object)s.toUpperCase(Locale.ENGLISH));
            return list == null ? Collections.emptyList() : list;
        };
        Function mapper = role -> {
            PersistentEntity entity = (PersistentEntity)entityMapper.fun(role);
            HashSet result = new HashSet();
            result.addAll((Collection)function.fun(entity.getObjectModelHelper().getTable().getTableName().getValue()));
            for (TableInfoProvider table : entity.getObjectModelHelper().getSecondaryTables()) {
                result.addAll((Collection)function.fun(table.getTableName().getValue()));
            }
            return result;
        };
        return ContainerUtil.concat(roles, (Function)mapper);
    }

    @NotNull
    public static Collection<DbTable> getTableVariants(@NotNull Collection<DbDataSource> dataSources, @Nullable String schemaName) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(0);
        }
        if (dataSources.isEmpty()) {
            List<DbTable> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        boolean checkSchema = ORMReferencesUtil.containsIgnoreCase(ORMReferencesUtil.getAllowedSchemas(dataSources), schemaName, DB_ELEMENT_NAME_MAPPER);
        ArrayList<DbTable> result = new ArrayList<DbTable>();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<DbDataSource, DasObject>)((PairProcessor)(db, table) -> {
            if (!checkSchema || DasUtil.getSchema((DasObject)table) == DasUtil.NO_NAME || schemaName.equalsIgnoreCase(DasUtil.getSchema((DasObject)table))) {
                result.add((DbTable)DbImplUtil.findElement((DbDataSource)db, (DasObject)table));
            }
            return true;
        }));
        ArrayList<DbTable> arrayList = result;
        if (arrayList == null) {
            ORMReferencesUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<DbElement> getSchemaVariants(@NotNull Collection<DbDataSource> dataSources, @Nullable String tableName) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(3);
        }
        if (dataSources.isEmpty()) {
            List<DbElement> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (tableName == null || StringUtil.isEmpty((String)tableName)) {
            Collection<DbElement> collection = ORMReferencesUtil.getAllowedSchemas(dataSources);
            if (collection == null) {
                ORMReferencesUtil.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Ref foundAtLeastOne = new Ref((Object)Boolean.FALSE);
        ArrayList schemas = ContainerUtil.newArrayList();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<DbDataSource, DasObject>)((PairProcessor)(db, table) -> {
            if (tableName.equalsIgnoreCase(table.getName())) {
                foundAtLeastOne.set((Object)Boolean.TRUE);
                ContainerUtil.addIfNotNull((Collection)schemas, (Object)DbImplUtil.findElement((DbDataSource)db, (DasObject)table.getDbParent()));
            }
            return true;
        }));
        Collection<Object> collection = (Boolean)foundAtLeastOne.get() != false ? schemas : ORMReferencesUtil.getAllowedSchemas(dataSources);
        if (collection == null) {
            ORMReferencesUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static <T> List<T> getColumnVariants(Collection<DbDataSource> dataSources, TableInfo tableInfo, Function<DbColumn, T> mapper) {
        if (dataSources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ORMReferencesUtil.processTables(dataSources, (PairProcessor<DbDataSource, DasObject>)((PairProcessor)(db, table) -> {
            if (ORMReferencesUtil.isTableAccepted(table, tableInfo)) {
                for (DasColumn column : DasUtil.getColumns((DasObject)table)) {
                    ContainerUtil.addIfNotNull((Collection)list, (Object)mapper.fun((Object)((DbColumn)DbImplUtil.findElement((DbDataSource)db, (DasObject)column))));
                }
            }
            return true;
        }));
        return list;
    }

    @NotNull
    public static Collection<DbElement> getCatalogVariants(@NotNull Collection<DbDataSource> dataSources) {
        if (dataSources == null) {
            ORMReferencesUtil.$$$reportNull$$$0(7);
        }
        if (dataSources.isEmpty()) {
            List<DbElement> list = Collections.emptyList();
            if (list == null) {
                ORMReferencesUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (DbDataSource dataSource : dataSources) {
            for (DasObject o : dataSource.getModel().getModelRoots()) {
                result.add((DbElement)o);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ORMReferencesUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean processTables(Collection<DbDataSource> dataSources, PairProcessor<DbDataSource, DasObject> processor) {
        for (DbDataSource dataSource : dataSources) {
            for (DasTable o : DasUtil.getTables((DatabaseSystem)dataSource)) {
                if (processor.process((Object)dataSource, (Object)o)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean containsIgnoreCase(Iterable<? extends T> collection, String string, Function<T, String> mapper) {
        return ORMReferencesUtil.findIgnoreCase(collection, string, mapper) != null;
    }

    @Nullable
    public static <T> T findIgnoreCase(Iterable<? extends T> collection, String string, Function<T, String> mapper) {
        for (T t : collection) {
            String str = (String)mapper.fun(t);
            if (str == null || !str.equalsIgnoreCase(string)) continue;
            return t;
        }
        return null;
    }

    public static Collection<? extends PersistentAttribute> getPersistenceAttributes(PsiMember psiMember, Boolean isCMR) {
        PsiClass psiClass;
        if (psiMember == null) {
            return Collections.emptyList();
        }
        if (psiMember instanceof PsiClass) {
            psiClass = (PsiClass)psiMember;
        } else {
            PsiType psiType = PersistenceCommonUtil.getTargetEntityType((PsiMember)psiMember);
            PsiClass psiClass2 = psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
        }
        if (psiClass == null) {
            return Collections.emptyList();
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiMember);
        ArrayList<PersistentAttribute> result = new ArrayList<PersistentAttribute>();
        for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
            for (PersistentAttribute attribute : browser.queryAttributes(object)) {
                if (attribute instanceof PersistentTransientAttribute || isCMR != null && isCMR != attribute instanceof PersistentRelationshipAttribute) continue;
                result.add(attribute);
            }
        }
        return result;
    }

    @Nullable
    public static String getStringParameter(PsiAnnotation psiAnnotation, String paramName) {
        return QuotedValueConverter.unquote((String)((String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)psiAnnotation.findAttributeValue(paramName), String.class)));
    }

    @Nullable
    public static TableInfo getTableInfo(PsiAnnotation psiAnnotation, String tableNameAttributeName) {
        String tableName = ORMReferencesUtil.getStringParameter(psiAnnotation, tableNameAttributeName);
        if (StringUtil.isEmpty((String)tableName)) {
            if ("javax.persistence.Table".equals(psiAnnotation.getQualifiedName())) {
                return ORMReferencesUtil.getEntityTableInfo((PsiElement)psiAnnotation, null, "");
            }
            return null;
        }
        return new TableInfo(tableName, ORMReferencesUtil.getStringParameter(psiAnnotation, "schema"), ORMReferencesUtil.getStringParameter(psiAnnotation, "catalog"));
    }

    public static Collection<DbElement> getAllowedSchemas(Collection<DbDataSource> dataSources) {
        ArrayList list = ContainerUtil.newArrayList();
        for (DbDataSource dataSource : dataSources) {
            for (DasObject o : DasUtil.getSchemas((DatabaseSystem)dataSource)) {
                list.add(DbImplUtil.findElement((DbDataSource)dataSource, (DasObject)o));
            }
        }
        return list;
    }

    @Nullable
    public static TableInfo getEntityTableInfo(PsiElement element, PsiElement sourceElement) {
        return ORMReferencesUtil.getEntityTableInfo(element, sourceElement, null);
    }

    @Nullable
    public static TableInfo getEntityTableInfo(PsiElement element, @Nullable PsiElement sourceElement, @Nullable String tableName) {
        if (element == null) {
            return null;
        }
        PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
        if (psiClass == null) {
            return null;
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)ORMReferencesUtil.getTargetClass(sourceElement));
        for (PersistentObject object : browser.queryPersistentObjects(psiClass)) {
            if (!(object instanceof PersistentEntity)) continue;
            return ORMReferencesUtil.getEntityTableInfo((PersistentEntity)object, tableName, browser);
        }
        return NO_TABLE_INFO;
    }

    @Nullable
    public static TableInfo getEntityTableInfo(@NotNull PersistentEntity entity, @Nullable String tableName) {
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(10);
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)entity.getIdentifyingPsiElement());
        return ORMReferencesUtil.getEntityTableInfo(entity, tableName, browser);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static TableInfo getEntityTableInfo(@NotNull PersistentEntity entity, @Nullable String tableName, PersistenceModelBrowser browser) {
        PersistentEntity persistentEntity;
        PsiClass firstClass;
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(11);
        }
        if ((firstClass = (PsiClass)entity.getClazz().getValue()) == null) {
            return ORMReferencesUtil.getEntityTableInfoInner(entity, tableName);
        }
        List classes = JamCommonUtil.getSuperClassList((PsiClass)firstClass.getSuperClass());
        if (classes.isEmpty()) {
            return ORMReferencesUtil.getEntityTableInfoInner(entity, tableName);
        }
        PersistentEntity curEntity = entity;
        PersistentEntity defaultEntity = null;
        block5: for (PsiClass aClass : classes) {
            if (aClass == firstClass) continue;
            PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass);
            int n = persistenceClassRoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                PersistenceClassRole role = persistenceClassRoleArray[n2];
                if (role.getType() == PersistenceClassRoleEnum.ENTITY && browser.acceptsRole(role)) {
                    PersistentEntity superEntity = (PersistentEntity)role.getPersistentObject();
                    PersistenceInheritanceType type = superEntity.getObjectModelHelper().getInheritanceType(entity);
                    if (type == null) {
                        defaultEntity = superEntity;
                    } else {
                        switch (type) {
                            case JOINED: {
                                defaultEntity = null;
                                break block5;
                            }
                            case SINGLE_TABLE: {
                                defaultEntity = null;
                                curEntity = superEntity;
                                break;
                            }
                            case TABLE_PER_CLASS: {
                                defaultEntity = null;
                                break block5;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        if (defaultEntity != null) {
            persistentEntity = defaultEntity;
            return ORMReferencesUtil.getEntityTableInfoInner(persistentEntity, tableName);
        }
        persistentEntity = curEntity;
        return ORMReferencesUtil.getEntityTableInfoInner(persistentEntity, tableName);
    }

    @Nullable
    public static TableInfo getEntityTableInfoInner(@NotNull PersistentEntity entity, @Nullable String tableName) {
        if (entity == null) {
            ORMReferencesUtil.$$$reportNull$$$0(12);
        }
        boolean noCheckTable = StringUtil.isEmpty((String)tableName);
        TableInfoProvider primaryTable = entity.getObjectModelHelper().getTable();
        String name = (String)primaryTable.getTableName().getValue();
        if (name != null && (noCheckTable || name.equalsIgnoreCase(tableName))) {
            return new TableInfo(name, (String)primaryTable.getSchema().getValue(), (String)primaryTable.getCatalog().getValue());
        }
        for (TableInfoProvider curTable : entity.getObjectModelHelper().getSecondaryTables()) {
            String curName = (String)curTable.getTableName().getValue();
            if (curName == null || !noCheckTable && !curName.equalsIgnoreCase(tableName)) continue;
            return new TableInfo(curName, (String)curTable.getSchema().getValue(), (String)curTable.getCatalog().getValue());
        }
        return null;
    }

    public static <T extends DbElement> PsiReferenceProvider createStringBasedReferenceProvider(final Function<T, LookupElement> lookupMapper, final Function<PsiElement, Collection<T>> stringProvider, final String unresolvedMessagePattern) {
        return new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                String schemaName;
                PsiClass psiClass;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((psiClass = ORMReferencesUtil.getTargetClass(element)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String originalValue = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
                int startOffset = originalValue == (schemaName = QuotedValueConverter.unquote((String)originalValue)) ? 0 : ORMReferencesUtil.calculateQuoteLength(originalValue);
                int endOffset = originalValue == schemaName || QuotedValueConverter.quotationIsNotClosed((String)originalValue) ? 0 : startOffset;
                PsiReference[] psiReferenceArray = new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(element, startOffset, endOffset){

                    @NotNull
                    public ResolveResult[] multiResolve(boolean incompleteCode) {
                        if (this.shouldNotResolve()) {
                            if (ResolveResult.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return ResolveResult.EMPTY_ARRAY;
                        }
                        ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults((Collection)stringProvider.fun((Object)element), schemaName);
                        if (resolveResultArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return resolveResultArray;
                    }

                    @Override
                    public Collection<LookupElement> getVariantsCollection() {
                        return ContainerUtil.map2List((Collection)((Collection)stringProvider.fun((Object)element)), (Function)lookupMapper);
                    }

                    @Override
                    @NotNull
                    public String getUnresolvedMessagePattern() {
                        String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : unresolvedMessagePattern;
                        if (string == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "multiResolve";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getUnresolvedMessagePattern";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/ORMReferencesUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/ORMReferencesUtil$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static int calculateQuoteLength(String quotedValue) {
        char q = quotedValue.charAt(0);
        return q == '\"' ? 2 : 1;
    }

    public static PsiReferenceProvider createTableNameReferenceProvider(final Function<PsiElement, Collection<DbTable>> tablesProvider) {
        return new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                String tableName;
                PsiClass psiClass;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((psiClass = ORMReferencesUtil.getTargetClass(element)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String originalValue = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
                int startOffset = originalValue == (tableName = QuotedValueConverter.unquote((String)originalValue)) ? 0 : ORMReferencesUtil.calculateQuoteLength(originalValue);
                int endOffset = originalValue == tableName || QuotedValueConverter.quotationIsNotClosed((String)originalValue) ? 0 : startOffset;
                PsiReference[] psiReferenceArray = new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(element, startOffset, endOffset){

                    @NotNull
                    public ResolveResult[] multiResolve(boolean incompleteCode) {
                        if (this.shouldNotResolve()) {
                            if (ResolveResult.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return ResolveResult.EMPTY_ARRAY;
                        }
                        ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults((Collection)tablesProvider.fun((Object)element), tableName);
                        if (resolveResultArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return resolveResultArray;
                    }

                    @Override
                    public Collection<LookupElement> getVariantsCollection() {
                        return ContainerUtil.map2List((Collection)((Collection)tablesProvider.fun((Object)element)), TABLE_LOOKUP_MAPPER);
                    }

                    @Override
                    @NotNull
                    public String getUnresolvedMessagePattern() {
                        String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : JpaMessages.message((String)"cannot.resolve.table.0", (Object[])new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "multiResolve";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getUnresolvedMessagePattern";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/ORMReferencesUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/ORMReferencesUtil$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static PsiReferenceProvider createColumnNameReferenceProvider(final Function<PsiElement, TableInfo> tableFunction) {
        return new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String columnName;
                PsiClass psiClass;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((psiClass = ORMReferencesUtil.getTargetClass(element)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String originalValue = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
                int startOffset = originalValue == (columnName = QuotedValueConverter.unquote((String)originalValue)) ? 0 : ORMReferencesUtil.calculateQuoteLength(originalValue);
                int endOffset = originalValue == columnName || QuotedValueConverter.quotationIsNotClosed((String)originalValue) ? 0 : startOffset;
                final TableInfo tableInfo = (TableInfo)tableFunction.fun((Object)element);
                if (tableInfo == NO_TABLE_INFO) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new QuotedPsiReferenceBase<PsiElement>(element, startOffset, endOffset){

                    @NotNull
                    public ResolveResult[] multiResolve(boolean incompleteCode) {
                        if (this.shouldNotResolve()) {
                            if (ResolveResult.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return ResolveResult.EMPTY_ARRAY;
                        }
                        List<ResolveResult> result = ORMReferencesUtil.getColumnVariants(PersistenceUtil.getDataSources((PsiClass)psiClass), tableInfo, columnElement -> {
                            if (Comparing.equal((String)columnElement.getName(), (String)columnName, (boolean)false)) {
                                return new PsiElementResolveResult((PsiElement)columnElement);
                            }
                            return null;
                        });
                        ResolveResult[] resolveResultArray = result.size() == 0 ? ResolveResult.EMPTY_ARRAY : result.toArray(new ResolveResult[result.size()]);
                        if (resolveResultArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return resolveResultArray;
                    }

                    @Override
                    public Collection<LookupElement> getVariantsCollection() {
                        Collection dataSources = PersistenceUtil.getDataSources((PsiClass)psiClass);
                        return ORMReferencesUtil.getColumnVariants(dataSources, tableInfo, COLUMN_LOOKUP_MAPPER);
                    }

                    @Override
                    @NotNull
                    public String getUnresolvedMessagePattern() {
                        String string = this.shouldNotResolve() ? super.getUnresolvedMessagePattern() : JpaMessages.message((String)"cannot.resolve.column.0", (Object[])new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "multiResolve";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getUnresolvedMessagePattern";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/ORMReferencesUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/ORMReferencesUtil$3";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static ResolveResult[] getDbElementResolveResults(Collection<? extends DbElement> elements, String name) {
        SmartList result = new SmartList();
        ContainerUtil.process(elements, object -> {
            if (Comparing.equal((String)object.getName(), (String)name, (boolean)false)) {
                result.add((Object)new PsiElementResolveResult((PsiElement)object));
            }
            return true;
        });
        return result.size() == 0 ? ResolveResult.EMPTY_ARRAY : (ResolveResult[])result.toArray((Object[])new ResolveResult[result.size()]);
    }

    @Nullable
    public static PsiMember getTargetMember(PsiElement element, boolean allowClass) {
        PsiMember thisMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class, (boolean)false);
        if (thisMember == null) {
            return null;
        }
        if (thisMember instanceof PsiClass && !allowClass) {
            return null;
        }
        return (PsiMember)CompletionUtil.getOriginalElement((PsiElement)thisMember);
    }

    @Nullable
    public static PsiClass getTargetClass(PsiElement element) {
        PsiMember member = ORMReferencesUtil.getTargetMember(element, true);
        return member instanceof PsiClass ? (PsiClass)member : (member != null ? member.getContainingClass() : null);
    }

    public static boolean isTableAccepted(DasObject dbTable, TableInfo tableInfo) {
        return !(tableInfo != null && (tableInfo.name != null && !tableInfo.name.equalsIgnoreCase(dbTable.getName()) || !StringUtil.isEmpty((String)tableInfo.schema) && !tableInfo.schema.equalsIgnoreCase(DasUtil.getSchema((DasObject)dbTable)) || !StringUtil.isEmpty((String)tableInfo.catalog) && !tableInfo.catalog.equalsIgnoreCase(DasUtil.getCatalog((DasObject)dbTable))));
    }

    public static Collection<LookupElement> setTailType(Collection<LookupElement> variantsCollection, String quoteSign) {
        if (StringUtil.isEmpty((String)quoteSign)) {
            return variantsCollection;
        }
        MyTailType tailType = new MyTailType(quoteSign);
        return ContainerUtil.map(variantsCollection, element -> TailTypeDecorator.withTail((LookupElement)element, (TailType)tailType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ORMReferencesUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ORMReferencesUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVariants";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalogVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTableVariants";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCatalogVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEntityTableInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEntityTableInfoInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTailType
    extends TailType {
        private final String myText;

        public MyTailType(String text) {
            this.myText = text;
        }

        public int processTail(Editor editor, int tailOffset) {
            if (StringUtil.isEmpty((String)this.myText)) {
                return tailOffset;
            }
            editor.getDocument().insertString(tailOffset, (CharSequence)this.myText);
            return MyTailType.moveCaret((Editor)editor, (int)tailOffset, (int)this.myText.length());
        }
    }

    public static abstract class QuotedPsiReferenceBase<T extends PsiElement>
    extends DataSourceRelatedReference<T> {
        private final int myStartOffset;
        private final int myEndOffset;

        public QuotedPsiReferenceBase(T element, int startOffset, int endOffset) {
            super(element);
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        protected TextRange calculateDefaultRangeInElement() {
            TextRange textRange = super.calculateDefaultRangeInElement();
            return this.myStartOffset == 0 && this.myEndOffset == 0 ? textRange : new TextRange(textRange.getStartOffset() + this.myStartOffset, textRange.getEndOffset() - this.myEndOffset);
        }

        protected boolean shouldNotResolve() {
            return this.myStartOffset != this.myEndOffset;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DomBundle.message((String)"message.invalid.value.quotation", (Object[])new Object[0]);
            if (string == null) {
                QuotedPsiReferenceBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        public abstract Collection<LookupElement> getVariantsCollection();

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = this.setTailType(this.getVariantsCollection()).toArray();
            if (objectArray == null) {
                QuotedPsiReferenceBase.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private Collection<LookupElement> setTailType(Collection<LookupElement> variantsCollection) {
            if (this.myStartOffset == 0) {
                return variantsCollection;
            }
            int start = super.calculateDefaultRangeInElement().getStartOffset();
            String quote = this.getElement().getText().substring(start, start + this.myStartOffset);
            return ORMReferencesUtil.setTailType(variantsCollection, quote);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/ORMReferencesUtil$QuotedPsiReferenceBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class DataSourceRelatedReference<T extends PsiElement>
    extends PsiPolyVariantReferenceBase<T>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        protected DataSourceRelatedReference(T element) {
            super(element);
        }

        public LocalQuickFix[] getQuickFixes() {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            if (facets.isEmpty()) {
                return JpaDomFacetInspection.createAddFacetQuickFix(JamCommonUtil.getAllDependentModules((Module)module));
            }
            return JpaDataSourceORMInspection.createUnitDataSourceQuickFixes((PersistenceMappings)new EntityMappingsImpl(module));
        }
    }

    public static class TableInfo {
        String name;
        String schema;
        String catalog;

        public TableInfo(String name, String schema, String catalog) {
            this.name = name;
            this.schema = schema;
            this.catalog = catalog;
        }
    }
}

