/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlObjectSelectExpression;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlScriptModel
extends ScriptModel<PsiElement> {
    private final VirtualFile myVirtualFile;
    private final PsiManager myManager;
    private final Document myDocument;
    private final TextRange myRange;
    private final Computable<SyntaxTraverser<PsiElement>> myScript;

    public QlScriptModel(PsiFile file) {
        this(file.getManager(), file.getVirtualFile(), (Document)ObjectUtils.assertNotNull((Object)FileDocumentManager.getInstance().getDocument(file.getVirtualFile())), null);
    }

    private QlScriptModel(QlScriptModel model, TextRange range) {
        this(model.myManager, model.myVirtualFile, model.myDocument, range);
    }

    private QlScriptModel(@NotNull PsiManager manager, @NotNull VirtualFile file, @NotNull Document document, @Nullable TextRange range) {
        if (manager == null) {
            QlScriptModel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            QlScriptModel.$$$reportNull$$$0(1);
        }
        if (document == null) {
            QlScriptModel.$$$reportNull$$$0(2);
        }
        this.myManager = manager;
        this.myVirtualFile = file;
        this.myDocument = document;
        this.myRange = range;
        this.myScript = new Computable<SyntaxTraverser<PsiElement>>(){
            Language lang;
            SyntaxTraverser<PsiElement> ret;
            long timeStamp;
            CharSequence text;
            {
                this.lang = ((LanguageFileType)QlScriptModel.this.myVirtualFile.getFileType()).getLanguage();
                this.timeStamp = QlScriptModel.this.myDocument.getModificationStamp();
                this.text = QlScriptModel.this.myDocument.getImmutableCharSequence();
            }

            @NotNull
            public SyntaxTraverser<PsiElement> compute() {
                if (this.ret != null && (QlScriptModel.this.myRange != null || this.timeStamp == QlScriptModel.this.myDocument.getModificationStamp())) {
                    SyntaxTraverser<PsiElement> syntaxTraverser = this.ret;
                    if (syntaxTraverser == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return syntaxTraverser;
                }
                this.ret = QlScriptModel.this.scriptDocImpl(this.lang, QlScriptModel.this.myRange != null ? this.text : (this.text = QlScriptModel.this.myDocument.getImmutableCharSequence()));
                if (QlScriptModel.this.myRange == null) {
                    this.timeStamp = QlScriptModel.this.myDocument.getModificationStamp();
                }
                SyntaxTraverser<PsiElement> syntaxTraverser = this.ret;
                if (syntaxTraverser == null) {
                    1.$$$reportNull$$$0(1);
                }
                return syntaxTraverser;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/QlScriptModel$1", "compute"));
            }
        };
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public ScriptModel<PsiElement> subModel(@Nullable TextRange range, boolean atPosition) {
        return new QlScriptModel(this, range);
    }

    public JBIterable<? extends ScriptModel.StatementIt<PsiElement>> statements() {
        return new SIt(this.statementsImpl((SyntaxTraverser<PsiElement>)((SyntaxTraverser)this.myScript.compute()))).cursor();
    }

    private SyntaxTraverser<PsiElement> statementsImpl(SyntaxTraverser<PsiElement> s) {
        if (this.myRange == null) {
            return (SyntaxTraverser)s.filter(Conditions.instanceOf(QlStatement.class));
        }
        boolean leavesOnly = this.myRange.getLength() > 0;
        Condition filter = Conditions.instanceOf((Class[])new Class[]{QlStatement.class, QlQueryExpression.class});
        Condition unparsedFileFilter = ScriptModelUtil.wholeFileCondition(s, (boolean)leavesOnly, QlStatement.class);
        Condition resultFilter = Conditions.or2((Condition)filter, (Condition)unparsedFileFilter);
        SyntaxTraverser adjusted = (SyntaxTraverser)((SyntaxTraverser)s.regard(filter)).filter(resultFilter);
        SyntaxTraverser ranged = ScriptModelUtil.inRange((SyntaxTraverser)adjusted, (TextRange)this.myRange);
        return (SyntaxTraverser)ranged.withTraversal(leavesOnly ? TreeTraversal.LEAVES_DFS : TreeTraversal.PRE_ORDER_DFS);
    }

    public JBIterable<? extends ScriptModel.ParamIt<PsiElement>> parameters() {
        return new PIt((SyntaxTraverser<PsiElement>)((SyntaxTraverser)((SyntaxTraverser)this.myScript.compute()).filter(Conditions.instanceOf(QlInputParameter.class)))).cursor();
    }

    public TextRange getTextRange() {
        return this.myRange;
    }

    public boolean isAtPosition() {
        return false;
    }

    public <EE> ScriptModel<EE> rawTransform(Function<SyntaxTraverser<PsiElement>, SyntaxTraverser<EE>> transform) {
        throw new UnsupportedOperationException();
    }

    private SyntaxTraverser<PsiElement> scriptDocImpl(Language lang, CharSequence documentText) {
        boolean inRange = this.myRange != null && this.myRange.getLength() > 0;
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(lang, documentText));
        if (inRange) {
            s = ScriptModelUtil.inRange((SyntaxTraverser)s, (TextRange)this.myRange);
        }
        return s;
    }

    @NotNull
    public List<String> statementType(SIt it) {
        QlSelectClause selectClause;
        QlQueryExpression query = (QlQueryExpression)ObjectUtils.tryCast((Object)it.current(), QlQueryExpression.class);
        QlSelectClause qlSelectClause = selectClause = query == null ? null : query.getSelectClause();
        if (selectClause != null) {
            List<QlExpression> list = selectClause.getExpressionList();
            ArrayList<String> strings = new ArrayList<String>(list.size());
            for (QlExpression expression : list) {
                if (expression instanceof QlAliasDefinition) {
                    strings.add(((QlAliasDefinition)expression).getName());
                    continue;
                }
                if (expression instanceof QlObjectSelectExpression) {
                    QlReferenceExpression ref = ((QlObjectSelectExpression)expression).getReferenceExpression();
                    strings.add(ref == null ? "object" : ref.getText());
                    continue;
                }
                strings.add(expression.getText());
            }
            ArrayList<String> arrayList = strings;
            if (arrayList == null) {
                QlScriptModel.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            QlScriptModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/QlScriptModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/QlScriptModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "statementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PIt
    extends MIt<PIt>
    implements ScriptModel.ParamIt<PsiElement> {
        PIt(SyntaxTraverser<PsiElement> s) {
            super(s);
        }

        public String displayName() {
            String s = this.text();
            boolean fixed = "?".equals(s);
            return !fixed ? this.text() : this.name();
        }

        public Iterable<String> description() {
            return ScriptModelUtil.getRelativeSnippet((Object)this.current(), (SyntaxTraverser.Api)this.traverser.api);
        }

        public String name() {
            String known;
            String s = this.text();
            if ("?".equals(s)) {
                s = null;
            }
            return (known = ScriptModelUtil.ParamHelper.getParameterId((ScriptModel.ParamIt)this, (String)s, (UserDataHolder)QlScriptModel.this.myDocument)) != null ? known : (s != null ? s : "? #" + ((long)this.range().getStartOffset() + this.rangeOffset()));
        }
    }

    private class SIt
    extends MIt<SIt>
    implements ScriptModel.StatementIt<PsiElement> {
        SIt(SyntaxTraverser<PsiElement> s) {
            super(s);
        }

        public String text(ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<PsiElement>> paramCondition) {
            return ScriptModelUtil.statementText((ScriptModel.StatementIt)this, (ScriptModel.PStorage)storage, paramCondition);
        }

        public Object resultType(Object target) {
            return QlScriptModel.this.statementType(this);
        }

        public JBIterable<? extends ScriptModel.ParamIt<PsiElement>> parameters() {
            return new PIt((SyntaxTraverser<PsiElement>)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)this.traverser.reset()).withRoot(this.current())).filter(Conditions.instanceOf(QlInputParameter.class)))).cursor();
        }
    }

    private static class MIt<Self extends MIt<Self>>
    extends ScriptModel.ModelItBase<PsiElement, Self> {
        JBIterator<PsiElement> vIt;

        MIt(SyntaxTraverser<PsiElement> s) {
            this.traverser = s;
            this.vIt = JBIterator.from((Iterator)s.iterator());
        }

        protected PsiElement nextImpl() {
            return this.vIt.hasNext() ? (PsiElement)this.vIt.next() : (PsiElement)this.stop();
        }
    }
}

