/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.JpaProjectComponent;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerMethodImpl;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.annotations.mapping.ScopedEntityMappingsImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JpaJamContributor
extends SemContributor {
    private static Key<CachedValue<Collection<JamMemberMeta<?, ?>>>> NOT_ANNOTATED_METAS_KEY = Key.create((String)"NOT_ANNOTATED_METAS_KEY");

    public void registerSemProviders(SemRegistrar registrar) {
        JpaAttributeType.BASIC.getAttributeClass();
        EntityImpl.ENTITY_META.register(registrar, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.persistence.Entity"), JpaJamContributor.createClassPattern(PersistenceClassRoleEnum.ENTITY)}));
        EmbeddableImpl.EMBEDDABLE_META.register(registrar, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.persistence.Embeddable"), JpaJamContributor.createClassPattern(PersistenceClassRoleEnum.EMBEDDABLE)}));
        MappedSuperclassImpl.MAPPED_SUPERCLASS_META.register(registrar, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotation("javax.persistence.MappedSuperclass"), JpaJamContributor.createClassPattern(PersistenceClassRoleEnum.MAPPED_SUPERCLASS)}));
        EntityListenerImpl.ENTITY_LISTENER_META.register(registrar, JpaJamContributor.createEntityListenerPattern());
        AttributeBaseImpl.TRANSIENT_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Transient"));
        AttributeBaseImpl.BASIC_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Basic"));
        AttributeBaseImpl.ID_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Id")).andNot((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern())).andNot((ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(new String[]{"javax.persistence.OneToOne", "javax.persistence.ManyToOne"})));
        AttributeBaseImpl.VERSION_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Version"));
        AttributeBaseImpl.EMBEDDED_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Embedded"));
        AttributeBaseImpl.EMBEDDED_ID_ATTR_META.register(registrar, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.EmbeddedId"), ((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.Id")).and((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern())}));
        AttributeBaseImpl.MANY_TO_ONE_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.ManyToOne"));
        AttributeBaseImpl.MANY_TO_MANY_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.ManyToMany"));
        AttributeBaseImpl.ONE_TO_ONE_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.OneToOne"));
        AttributeBaseImpl.ONE_TO_MANY_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.OneToMany"));
        AttributeBaseImpl.BASIC_COLLECTION_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.ElementCollection")).andNot((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern()));
        AttributeBaseImpl.EMBEDDED_COLLECTION_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotation("javax.persistence.ElementCollection")).and((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern()));
        for (JamMemberMeta meta : AttributeType.getAllJamMetas()) {
            meta.register(registrar, (ElementPattern)JpaJamContributor.createNotAnnotatedOrXmlPattern((JamMemberMeta<PsiMember, ? extends JamAttributeBase>)meta));
        }
        EntityListenerMethodImpl.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(new String[]{"javax.persistence.PostLoad", "javax.persistence.PostPersist", "javax.persistence.PostRemove", "javax.persistence.PostUpdate", "javax.persistence.PrePersist", "javax.persistence.PreRemove", "javax.persistence.PreUpdate"}));
    }

    private static PsiMemberPattern.Capture createHasEmbeddableTargetPattern() {
        return (PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().with((PatternCondition)new PatternCondition<PsiMember>("hasEmbeddableTarget"){

            public boolean accepts(@NotNull PsiMember psiMember, ProcessingContext context) {
                if (psiMember == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JpaJamContributor.hasEmbeddableTarget(psiMember);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$1", "accepts"));
            }
        });
    }

    private static boolean hasEmbeddableTarget(PsiMember psiMember) {
        JavaTypeInfo pair = PersistenceCommonUtil.getTypeInfo((PsiType)PropertyUtil.getPropertyType((PsiMember)psiMember));
        return JpaUtil.isPersistentObject(pair.getValueType(), PersistenceClassRoleEnum.EMBEDDABLE);
    }

    private static PsiMemberPattern.Capture createNotAnnotatedOrXmlPattern(final JamMemberMeta<PsiMember, ? extends JamAttributeBase> meta) {
        return (PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().with((PatternCondition)new PatternCondition<PsiMember>("notAnnotatedAttribute"){

            public boolean accepts(@NotNull PsiMember member, ProcessingContext context) {
                if (member == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(member instanceof PsiField) && !(member instanceof PsiMethod)) {
                    return false;
                }
                if (member.getContainingClass() == null) {
                    return false;
                }
                if (member.hasModifierProperty("static") || member.hasModifierProperty("transient")) {
                    return false;
                }
                CachedValue cachedValue = (CachedValue)member.getUserData(NOT_ANNOTATED_METAS_KEY);
                if (cachedValue == null) {
                    cachedValue = CachedValuesManager.getManager((Project)member.getProject()).createCachedValue(() -> {
                        if (member == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return new CachedValueProvider.Result((Object)JpaJamContributor.createAttributeMetaSet(member), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                    }, false);
                    member.putUserData(NOT_ANNOTATED_METAS_KEY, (Object)cachedValue);
                }
                return ((Collection)cachedValue.getValue()).contains(meta);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "member";
                objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accepts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$accepts$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static Collection<JamMemberMeta<?, ?>> createAttributeMetaSet(PsiMember member) {
        JamMemberMeta<PsiMember, AttributeBaseImpl.EmbeddedAttr> defaultMeta;
        PsiMethod counterPart;
        boolean isMethod = member instanceof PsiMethod;
        PsiClass containingClass = member.getContainingClass();
        assert (containingClass != null);
        if (member instanceof PsiMethod && PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)member))) {
            counterPart = containingClass.findFieldByName(PropertyUtil.getPropertyNameByGetter((PsiMethod)((PsiMethod)member)), false);
        } else if (member instanceof PsiField) {
            counterPart = PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)member.getName(), (boolean)false, (boolean)false);
        } else {
            return Collections.emptyList();
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Set)AttributeType.getAttributeAnnotations()) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)counterPart, (Set)AttributeType.getAttributeAnnotations()) != null) {
            return Collections.emptyList();
        }
        PersistenceClassRole[] classRoles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)containingClass);
        if (classRoles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JamMemberMeta[]> metasList = new ArrayList<JamMemberMeta[]>();
        boolean addDefaultAttr = false;
        block0: for (PersistenceClassRole role : classRoles) {
            PersistentObjectImpl annoObject;
            PersistentObject object = role.getPersistentObject();
            if (object == null || (annoObject = (PersistentObjectImpl)((Object)ModelMergerUtil.getImplementation((Object)object, PersistentObjectImpl.class))) == null) continue;
            PropertyMemberType memberType = object.getObjectModelHelper().getDefaultAccessMode();
            if (isMethod && memberType == PropertyMemberType.FIELD || !isMethod && memberType == PropertyMemberType.GETTER) continue;
            addDefaultAttr = true;
            String name = PropertyUtil.getPropertyName((PsiMember)member);
            for (PersistentObject impl : ModelMergerUtil.getImplementations((Object)object)) {
                if (!(impl instanceof DomElement)) continue;
                for (PersistentAttribute attribute : impl.getObjectModelHelper().getAttributes()) {
                    if (!Comparing.equal((String)name, (String)((String)attribute.getName().getValue()))) continue;
                    addDefaultAttr = false;
                    if (!member.getManager().areElementsEquivalent((PsiElement)member, (PsiElement)attribute.getPsiMember())) continue block0;
                    AttributeType type = AttributeType.getAttributeType((PersistentAttribute)attribute);
                    JamMemberMeta[] metas = type.getJamMetas();
                    if (metas.length <= 0) continue;
                    metasList.add(metas);
                }
            }
        }
        Object object = !addDefaultAttr ? null : (defaultMeta = JpaJamContributor.hasEmbeddableTarget(member) ? AttributeBaseImpl.EMBEDDED_ATTR_META : AttributeBaseImpl.BASIC_ATTR_META);
        if (metasList.isEmpty()) {
            return ContainerUtil.createMaybeSingletonList(defaultMeta);
        }
        ArrayList result = new ArrayList(metasList.size());
        for (JamMemberMeta[] metas : metasList) {
            result.add(metas[0]);
        }
        if (defaultMeta != null && !result.contains(defaultMeta)) {
            result.add(defaultMeta);
        }
        for (JamMemberMeta[] metas : metasList) {
            for (int i = 1; i < metas.length; ++i) {
                JamMemberMeta meta = metas[i];
                if (!result.contains(meta) || !result.contains(metas[0])) continue;
                result.remove(meta);
            }
        }
        return result;
    }

    private static PsiClassPattern createClassPattern(PersistenceClassRoleEnum type) {
        return (PsiClassPattern)PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlEnterpriseBean"){

            public boolean accepts(final @NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                CommonProcessors.FindFirstProcessor<PersistenceClassRole> processor = new CommonProcessors.FindFirstProcessor<PersistenceClassRole>(){

                    protected boolean accept(PersistenceClassRole role) {
                        PersistenceMappings annoMappings = role.getFacet().getAnnotationEntityMappings(role.getPersistenceUnit());
                        return annoMappings != null && (!(annoMappings instanceof ScopedEntityMappingsImpl) || ((ScopedEntityMappingsImpl)annoMappings).getCondition().value((Object)psiClass));
                    }
                };
                PersistenceRoleHolder.getInstance((Project)psiClass.getProject()).processXmlRoles(psiClass, (Processor)processor);
                return processor.isFound();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$3", "accepts"));
            }
        });
    }

    private static ElementPattern<? extends PsiClass> createEntityListenerPattern() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("isInEntityListenersAnnotation"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    4.$$$reportNull$$$0(0);
                }
                return ((Collection)((CachedValue)psiClass.getProject().getUserData(JpaProjectComponent.ENTITY_LISTENER_CLASSES_KEY)).getValue()).contains(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$4", "accepts"));
            }
        }), PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlEntityListener"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!psiClass.hasModifierProperty("public")) {
                    return false;
                }
                CommonProcessors.FindFirstProcessor<PersistenceClassRole> findFirstProcessor = new CommonProcessors.FindFirstProcessor<PersistenceClassRole>(){

                    protected boolean accept(PersistenceClassRole role) {
                        return role.getType() == PersistenceClassRoleEnum.ENTITY_LISTENER && role.getFacet().getAnnotationEntityMappings(role.getPersistenceUnit()) != null;
                    }
                };
                PersistenceRoleHolder.getInstance((Project)psiClass.getProject()).processXmlRoles(psiClass, (Processor)findFirstProcessor);
                return findFirstProcessor.isFound();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$5", "accepts"));
            }
        })});
    }
}

