/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws WebBrowserUrlProvider.BrowserException {
        String relativePath;
        if (request == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(0);
        }
        Project project = request.getProject();
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)request.getVirtualFile(), (Project)project);
        if (webFacet == null) {
            throw new WebBrowserUrlProvider.BrowserException(J2EEBundle.message((String)"browser.web.faced.not.configured", (Object[])new Object[0]));
        }
        AccessToken token = ReadAction.start();
        try {
            relativePath = JspDeploymentManager.getInstance().computeRelativeTargetPath(request.getFile(), webFacet);
        }
        finally {
            token.finish();
        }
        if (relativePath != null) {
            ProcessHandler[] handlers;
            Set<String> urlPatterns = JspWebBrowserUrlProvider.processServletMappingUrlPatterns(relativePath, webFacet);
            for (ProcessHandler handler : handlers = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
                if (handler.isProcessTerminated() || handler.isProcessTerminating() || !handler.isStartNotified() || !(handler instanceof J2EEProcess)) continue;
                J2EEServerInstance serverInstance = ((J2EEProcess)handler).getServerInstance();
                CommonModel commonModel = serverInstance.getCommonModel();
                DeploymentModel deploymentModel = DeploymentManagerEx.getInstanceEx(project).getModelForFacet(commonModel, (JavaeeFacet)webFacet);
                if (deploymentModel == null) continue;
                AppServerDeployedFileUrlProvider deployedFileUrlProvider = commonModel.getIntegration().getDeployedFileUrlProvider();
                THashSet urls = new THashSet();
                for (String urlPattern : urlPatterns) {
                    String url = deployedFileUrlProvider instanceof ApplicationServerUrlMapping ? ((ApplicationServerUrlMapping)deployedFileUrlProvider).getUrlForDeployedFile(serverInstance, deploymentModel, (JavaeeFacet)webFacet, urlPattern) : deployedFileUrlProvider.getUrlForDeployedFile(serverInstance, deploymentModel, urlPattern);
                    if (url == null) continue;
                    ContainerUtilRt.addIfNotNull((Collection)urls, (Object)Urls.parseFromIdea((CharSequence)url));
                }
                THashSet tHashSet = urls;
                if (tHashSet == null) {
                    JspWebBrowserUrlProvider.$$$reportNull$$$0(1);
                }
                return tHashSet;
            }
        }
        throw new WebBrowserUrlProvider.BrowserException(J2EEBundle.message((String)"browser.no.suitable.configuration.running", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Set<String> processServletMappingUrlPatterns(@NotNull String path, @NotNull WebFacet facet) {
        List mappings;
        if (path == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(3);
        }
        AccessToken token = ReadAction.start();
        try {
            WebApp root = facet.getRoot();
            mappings = root == null ? Collections.emptyList() : root.getServletMappings();
        }
        finally {
            token.finish();
        }
        if (mappings.isEmpty()) {
            Set<String> set = Collections.singleton(path);
            if (set == null) {
                JspWebBrowserUrlProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        THashSet paths = new THashSet();
        for (ServletMapping servletMapping : mappings) {
            CommonServlet servlet = (CommonServlet)servletMapping.getServletName().getValue();
            if (servlet == null) continue;
            for (GenericDomValue pattern : servletMapping.getUrlPatterns()) {
                String value = (String)pattern.getValue();
                if (value == null) continue;
                ContainerUtilRt.addIfNotNull((Collection)paths, (Object)JspWebBrowserUrlProvider.getPath(path, value.trim()));
            }
        }
        THashSet tHashSet = paths;
        if (tHashSet == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(5);
        }
        return tHashSet;
    }

    @Nullable
    private static String getPath(@NotNull String filePath, @NotNull String servletMapping) {
        String extension;
        if (filePath == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(6);
        }
        if (servletMapping == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(7);
        }
        if (servletMapping.startsWith("/")) {
            if (servletMapping.endsWith("/*")) {
                return servletMapping.substring(0, servletMapping.lastIndexOf("/*")) + filePath;
            }
            if (servletMapping.endsWith("*") || !servletMapping.contains("*")) {
                // empty if block
            }
        }
        if (servletMapping.startsWith("*.") && StringUtil.isNotEmpty((String)(extension = servletMapping.substring(servletMapping.indexOf("*.") + 2)))) {
            int index = filePath.lastIndexOf(46);
            String nameWithoutExtension = index < 0 ? filePath : filePath.substring(0, index);
            return nameWithoutExtension + "." + extension;
        }
        return null;
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Language language;
        if (request == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(8);
        }
        if ((language = request.getFile().getViewProvider().getBaseLanguage()) == PlainTextLanguage.INSTANCE) {
            return false;
        }
        if (StdLanguages.JSP == language || StdFileTypes.JSPX.getLanguage() == language) {
            return true;
        }
        if (HtmlUtil.isHtmlFile((PsiElement)request.getFile())) {
            return WebUtil.getWebFacet((VirtualFile)request.getVirtualFile(), (Project)request.getProject()) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/JspWebBrowserUrlProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/JspWebBrowserUrlProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processServletMappingUrlPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processServletMappingUrlPatterns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canHandleElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

