/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.SpringClassAnnotator;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringImplicitUsageProvider
implements ImplicitUsageProvider {
    @NonNls
    private static final List<String> WRITE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Required", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.context.event.EventListener", "org.springframework.transaction.annotation.Transactional", "javax.transaction.Transactional", "org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction"});
    private static final List<String> NON_SPRING_WRITE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"javax.inject.Inject", "javax.annotation.Resource"});
    private static final List<String> READ_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.beans.factory.annotation.Value"});

    public boolean isImplicitUsage(PsiElement element) {
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || SpringImplicitUsageProvider.isBeanClassOrConstructor(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), READ_ANNOTATIONS);
    }

    private static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)element, SpringImplicitUsageProvider.getMetaAnnotations(module, "org.springframework.scheduling.annotation.Scheduled", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.messaging.handler.annotation.MessageMapping"));
    }

    @NotNull
    private static List<String> getMetaAnnotations(@NotNull Module module, String ... annotations) {
        if (module == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        List annotationTypes = ContainerUtil.newSmartList();
        for (String annotation : annotations) {
            annotationTypes.addAll(MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotation, (boolean)false));
        }
        List fqns = ContainerUtil.mapNotNull((Collection)annotationTypes, (Function)((NullableFunction)PsiClass::getQualifiedName));
        ContainerUtil.removeAll((Collection)fqns, (Object[])annotations);
        List list = fqns;
        if (list == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), NON_SPRING_WRITE_ANNOTATIONS);
    }

    private static boolean hasWriteAnnotation(PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        return !(!SpringCommonUtils.hasSpringFacets((Project)element.getProject()) && !SpringLibraryUtil.hasSpringLibrary((Project)element.getProject()) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, WRITE_ANNOTATIONS) && !SpringImplicitUsageProvider.isMetaAnnotated(modifierListOwner));
    }

    private static boolean isBeanSetterOrLifeCycleMethod(PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass psiClass = method.getContainingClass();
            PsiIdentifier identifier = method.getNameIdentifier();
            if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass) && identifier != null) {
                SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                return info.isMappedProperty(method) || info.isAutowired() && SpringClassAnnotator.checkAutowiredMethod(method, null, info, identifier) || !info.getMethodTypes(method).isEmpty();
            }
        }
        return false;
    }

    private static boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return SpringImplicitUsageProvider.isMappedBeanClass((PsiClass)element);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return SpringImplicitUsageProvider.isMappedBeanClass(containingClass);
        }
        return false;
    }

    private static boolean isMappedBeanClass(PsiClass containingClass) {
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)containingClass) && SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)containingClass).isMapped();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/code/SpringImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/code/SpringImplicitUsageProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAnnotations";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

