/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class AbstractProxiedTypeResolver
extends AbstractTypeResolver {
    @NonNls
    protected static final String PROXY_CLASS_FLAG_PROPERTY_NAME = "proxyTargetClass";
    @NonNls
    protected static final String OPTIMIZE_PROPERTY_NAME = "optimize";

    AbstractProxiedTypeResolver() {
    }

    @NotNull
    protected static Set<PsiClass> getAllInterfaces(@NotNull PsiType psiType) {
        if (psiType == null) {
            AbstractProxiedTypeResolver.$$$reportNull$$$0(0);
        }
        HashSet<PsiClass> interfaces = new HashSet<PsiClass>();
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                Set<PsiClass> set = Collections.emptySet();
                if (set == null) {
                    AbstractProxiedTypeResolver.$$$reportNull$$$0(1);
                }
                return set;
            }
            if (psiClass.isInterface()) {
                Set<PsiClass> set = Collections.singleton(psiClass);
                if (set == null) {
                    AbstractProxiedTypeResolver.$$$reportNull$$$0(2);
                }
                return set;
            }
            while (psiClass != null) {
                ContainerUtil.addAll(interfaces, (Object[])psiClass.getInterfaces());
                psiClass = psiClass.getSuperClass();
            }
        }
        HashSet<PsiClass> hashSet = interfaces;
        if (hashSet == null) {
            AbstractProxiedTypeResolver.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    protected static Set<String> getAllInterfaceNames(@NotNull PsiType type) {
        if (type == null) {
            AbstractProxiedTypeResolver.$$$reportNull$$$0(4);
        }
        Set<PsiClass> interfaces = AbstractProxiedTypeResolver.getAllInterfaces(type);
        HashSet<String> names = new HashSet<String>(interfaces.size());
        for (PsiClass anInterface : interfaces) {
            names.add(anInterface.getQualifiedName());
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            AbstractProxiedTypeResolver.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    protected static boolean isCglibExplicitlyEnabled(@NotNull SpringBean context) {
        if (context == null) {
            AbstractProxiedTypeResolver.$$$reportNull$$$0(6);
        }
        return AbstractProxiedTypeResolver.isBooleanPropertySetAndTrue(context, PROXY_CLASS_FLAG_PROPERTY_NAME) || AbstractProxiedTypeResolver.isBooleanPropertySetAndTrue(context, OPTIMIZE_PROPERTY_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/AbstractProxiedTypeResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfaceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterfaces";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterfaceNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCglibExplicitlyEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

