/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractTypeResolver
implements ObjectTypeResolver {
    @NonNls
    private static final String CLASS_ARRAY_EDITOR_SEPARATOR = ",";

    AbstractTypeResolver() {
    }

    @Nullable
    protected static String getPropertyValue(@Nullable CommonSpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition property;
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(0);
        }
        if (bean instanceof SpringBean && (property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName)) != null) {
            return property.getValueAsString();
        }
        return null;
    }

    @NotNull
    protected static Set<String> getListOrSetValues(@NotNull SpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition property;
        if (bean == null) {
            AbstractTypeResolver.$$$reportNull$$$0(1);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(2);
        }
        if ((property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)propertyName)) instanceof SpringProperty) {
            Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
            if (set == null) {
                AbstractTypeResolver.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractTypeResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    protected static Set<String> getTypesFromClassArrayProperty(@NotNull SpringBean context, String propertyName) {
        SpringPropertyDefinition property;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(5);
        }
        if ((property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName)) != null) {
            String stringValue = property.getValueAsString();
            if (stringValue != null) {
                Set<String> set = AbstractTypeResolver.splitAndTrim(stringValue, CLASS_ARRAY_EDITOR_SEPARATOR);
                if (set == null) {
                    AbstractTypeResolver.$$$reportNull$$$0(6);
                }
                return set;
            }
            if (property instanceof SpringProperty) {
                Set set = SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)property));
                if (set == null) {
                    AbstractTypeResolver.$$$reportNull$$$0(7);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AbstractTypeResolver.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Set<String> splitAndTrim(@NotNull String value, @NotNull String separator) {
        if (value == null) {
            AbstractTypeResolver.$$$reportNull$$$0(9);
        }
        if (separator == null) {
            AbstractTypeResolver.$$$reportNull$$$0(10);
        }
        List parts = StringUtil.split((String)value, (String)separator);
        HashSet<String> trimmedParts = new HashSet<String>(parts.size());
        for (String part : parts) {
            trimmedParts.add(part.trim());
        }
        HashSet<String> hashSet = trimmedParts;
        if (hashSet == null) {
            AbstractTypeResolver.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    protected static boolean isBooleanPropertySetAndTrue(@NotNull SpringBean context, @NotNull String propertyName) {
        String value;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(12);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(13);
        }
        return (value = AbstractTypeResolver.getPropertyValue((CommonSpringBean)context, propertyName)) != null && BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    protected static boolean isBooleanPropertySetAndFalse(@NotNull SpringBean context, @NotNull String propertyName) {
        String value;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(15);
        }
        return (value = AbstractTypeResolver.getPropertyValue((CommonSpringBean)context, propertyName)) != null && !BooleanValueConverter.getInstance((boolean)true).isTrue(value);
    }

    @Nullable
    protected static PsiType getTypeFromProperty(@NotNull SpringBean context, @NotNull String propertyName) {
        SpringPropertyDefinition targetProperty;
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(16);
        }
        if (propertyName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(17);
        }
        if ((targetProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)context, (String)propertyName)) != null) {
            SpringProperty property;
            SpringBean bean;
            if (targetProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = (property = (SpringProperty)targetProperty).getBean()))) {
                PsiType[] classes = BeanService.getInstance().getEffectiveBeanTypes((CommonSpringBean)bean);
                PsiManager psiManager = bean.getPsiManager();
                if (classes.length > 0 && psiManager != null) {
                    return classes[0];
                }
            }
            return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringPropertyUtils.findReferencedBean((SpringPropertyDefinition)targetProperty));
        }
        return null;
    }

    @Nullable
    protected static PsiClassType getTypeFromBeanName(@NotNull SpringBean context, @NotNull String beanName) {
        if (context == null) {
            AbstractTypeResolver.$$$reportNull$$$0(18);
        }
        if (beanName == null) {
            AbstractTypeResolver.$$$reportNull$$$0(19);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)context);
        return AbstractTypeResolver.getTypeFromNonFactoryBean(SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName));
    }

    @Nullable
    private static PsiClassType getTypeFromNonFactoryBean(@Nullable SpringBeanPointer bean) {
        PsiClass targetBeanClass;
        if (bean != null && (targetBeanClass = bean.getBeanClass()) != null && !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(targetBeanClass)) {
            return PsiTypesUtil.getClassType((PsiClass)targetBeanClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/AbstractTypeResolver";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/AbstractTypeResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOrSetValues";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFromClassArrayProperty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "splitAndTrim";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getListOrSetValues";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFromClassArrayProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "splitAndTrim";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanPropertySetAndTrue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanPropertySetAndFalse";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromProperty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromBeanName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

